/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.blocks.interfaces;

import com.bigdious.risus.init.RisusBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface DecomposingBlock
extends ChangeOverTimeBlock<DecomposeState> {
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)RisusBlocks.TISSUE.get()), (Object)((Block)RisusBlocks.ROTTING_TISSUE.get())).put((Object)((Block)RisusBlocks.ROTTING_TISSUE.get()), (Object)((Block)RisusBlocks.DECOMPOSING_TISSUE.get())).put((Object)((Block)RisusBlocks.DECOMPOSING_TISSUE.get()), (Object)((Block)RisusBlocks.DECAYING_TISSUE.get())).put((Object)((Block)RisusBlocks.DECAYING_TISSUE.get()), (Object)((Block)RisusBlocks.BONE_WALL.get())).build());

    public static Optional<Block> getNext(Block block) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)block));
    }

    default public Optional<BlockState> getNext(BlockState state) {
        return DecomposingBlock.getNext(state.getBlock()).map(block -> block.withPropertiesOf(state));
    }

    default public float getChanceModifier() {
        return this.getAge() == DecomposeState.NONE ? 0.75f : 1.0f;
    }

    public static enum DecomposeState {
        NONE,
        ROTTING,
        DECOMPOSING,
        DECAYING;

    }
}

