/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.model.entity.player;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class AngelWingsModel
extends HumanoidModel<LivingEntity> {
    private final ModelPart RightWing;
    private final ModelPart RightThreeQuarter;
    private final ModelPart RightTwoQuarter;
    private final ModelPart RightOneQuarter;
    private final ModelPart LeftWing;
    private final ModelPart LeftThreeQuarter;
    private final ModelPart LeftTwoQuarter;
    private final ModelPart LeftOneQuarter;

    public AngelWingsModel(ModelPart root) {
        super(root);
        this.RightWing = root.getChild("RightWing");
        this.RightThreeQuarter = this.RightWing.getChild("RightThreeQuarter");
        this.RightTwoQuarter = this.RightThreeQuarter.getChild("RightTwoQuarter");
        this.RightOneQuarter = this.RightTwoQuarter.getChild("RightOneQuarter");
        this.LeftWing = root.getChild("LeftWing");
        this.LeftThreeQuarter = this.LeftWing.getChild("LeftThreeQuarter");
        this.LeftTwoQuarter = this.LeftThreeQuarter.getChild("LeftTwoQuarter");
        this.LeftOneQuarter = this.LeftTwoQuarter.getChild("LeftOneQuarter");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition RightWing = partdefinition.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(29, 19).addBox(-1.1f, -1.0f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)2.0f, (float)2.0f, (float)0.232f, (float)-0.8035f, (float)-0.3171f));
        PartDefinition RightThreeQuarter = RightWing.addOrReplaceChild("RightThreeQuarter", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)0.4316f, (float)-0.656f, (float)0.2048f));
        PartDefinition RightFeatherOne_r1 = RightThreeQuarter.addOrReplaceChild("RightFeatherOne_r1", CubeListBuilder.create().texOffs(47, 19).addBox(0.0f, -2.0f, -1.0f, 0.0f, 6.0f, 7.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        PartDefinition RightMemberTwo_r1 = RightThreeQuarter.addOrReplaceChild("RightMemberTwo_r1", CubeListBuilder.create().texOffs(26, 10).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.0074f));
        PartDefinition RightTwoQuarter = RightThreeQuarter.addOrReplaceChild("RightTwoQuarter", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)7.0f, (float)-1.4668f, (float)-0.1365f, (float)-0.1373f));
        PartDefinition RightFeatherTwo_r1 = RightTwoQuarter.addOrReplaceChild("RightFeatherTwo_r1", CubeListBuilder.create().texOffs(44, -10).addBox(0.0f, -3.0f, -5.0f, 0.0f, 9.0f, 10.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)-0.0436f, (float)0.0f));
        PartDefinition RightMemberThree_r1 = RightTwoQuarter.addOrReplaceChild("RightMemberThree_r1", CubeListBuilder.create().texOffs(0, 10).addBox(-0.4f, 0.0f, -0.5f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.0074f));
        PartDefinition RightOneQuarter = RightTwoQuarter.addOrReplaceChild("RightOneQuarter", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)9.0f, (float)-0.7897f, (float)-0.1609f, (float)0.1716f));
        PartDefinition RightFeatherThree_r1 = RightOneQuarter.addOrReplaceChild("RightFeatherThree_r1", CubeListBuilder.create().texOffs(0, -20).addBox(0.0f, -2.0f, -1.0f, 0.0f, 10.0f, 20.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightMemberFour_r1 = RightOneQuarter.addOrReplaceChild("RightMemberFour_r1", CubeListBuilder.create().texOffs(0, 20).addBox(-0.4f, 0.0f, -0.5f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.0074f));
        PartDefinition LeftWing = partdefinition.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(29, 19).mirror().addBox(-0.9f, -1.0f, 0.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)2.0f, (float)2.0f, (float)0.232f, (float)0.8035f, (float)0.3171f));
        PartDefinition LeftThreeQuarter = LeftWing.addOrReplaceChild("LeftThreeQuarter", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)0.4316f, (float)0.656f, (float)-0.2048f));
        PartDefinition LeftFeatherOne_r1 = LeftThreeQuarter.addOrReplaceChild("LeftFeatherOne_r1", CubeListBuilder.create().texOffs(47, 19).mirror().addBox(0.0f, -2.0f, -1.0f, 0.0f, 6.0f, 7.0f, new CubeDeformation(0.02f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition LeftMemberTwo_r1 = LeftThreeQuarter.addOrReplaceChild("LeftMemberTwo_r1", CubeListBuilder.create().texOffs(26, 10).mirror().addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.1f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0074f));
        PartDefinition LeftTwoQuarter = LeftThreeQuarter.addOrReplaceChild("LeftTwoQuarter", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)7.0f, (float)-1.4668f, (float)0.1365f, (float)0.1373f));
        PartDefinition LeftFeatherTwo_r1 = LeftTwoQuarter.addOrReplaceChild("LeftFeatherTwo_r1", CubeListBuilder.create().texOffs(44, -10).mirror().addBox(0.0f, -3.0f, -5.0f, 0.0f, 9.0f, 10.0f, new CubeDeformation(0.02f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)4.0f, (float)0.0f, (float)0.0436f, (float)0.0f));
        PartDefinition LeftMemberThree_r1 = LeftTwoQuarter.addOrReplaceChild("LeftMemberThree_r1", CubeListBuilder.create().texOffs(0, 10).mirror().addBox(-0.6f, 0.0f, -0.5f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.1f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0074f));
        PartDefinition LeftOneQuarter = LeftTwoQuarter.addOrReplaceChild("LeftOneQuarter", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)9.0f, (float)-0.7897f, (float)0.1609f, (float)-0.1716f));
        PartDefinition LeftFeatherThree_r1 = LeftOneQuarter.addOrReplaceChild("LeftFeatherThree_r1", CubeListBuilder.create().texOffs(0, -20).mirror().addBox(0.0f, -2.0f, -1.0f, 0.0f, 10.0f, 20.0f, new CubeDeformation(0.02f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition LeftMemberFour_r1 = LeftOneQuarter.addOrReplaceChild("LeftMemberFour_r1", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(-0.6f, 0.0f, -0.5f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.1f, (float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0074f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 0.507271f;
        float f1 = -0.117359f;
        float f2 = 2.0f;
        float f3 = 0.655878f;
        float f5 = -1.48f;
        float f6 = -0.78f;
        if (entity.isFallFlying()) {
            float f4 = 1.0f;
            Vec3 vec3 = entity.getDeltaMovement();
            if (vec3.y < 0.0) {
                Vec3 vec31 = vec3.normalize();
                f4 = 1.0f - (float)Math.pow(-vec31.y, 1.5);
            }
            f = f4 * 1.5707964f + (1.0f - f4) * f1;
            f5 = f4 * 1.5707964f + (-1.15f - f4);
            f6 = f4 * 1.5707964f + (-1.25f - f4);
        } else if (entity.isCrouching()) {
            f = 0.7853982f;
            f2 = 5.0f;
            f5 = -0.9f;
            f6 = -0.4f;
        }
        this.LeftWing.y = f2;
        this.LeftTwoQuarter.xRot = f5;
        this.LeftOneQuarter.xRot = f6;
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)entity;
            abstractclientplayer.elytraRotX += (f - abstractclientplayer.elytraRotX) * 0.1f;
            abstractclientplayer.elytraRotY += (f3 - abstractclientplayer.elytraRotY) * 0.1f;
            abstractclientplayer.elytraRotZ += (f1 - abstractclientplayer.elytraRotZ) * 0.1f;
            this.LeftThreeQuarter.xRot = abstractclientplayer.elytraRotX;
            this.LeftThreeQuarter.yRot = abstractclientplayer.elytraRotY;
            this.LeftThreeQuarter.zRot = abstractclientplayer.elytraRotZ;
        } else {
            this.LeftThreeQuarter.xRot = f;
            this.LeftThreeQuarter.yRot = f3;
            this.LeftThreeQuarter.zRot = f1;
        }
        this.RightThreeQuarter.yRot = -this.LeftThreeQuarter.yRot;
        this.RightWing.y = this.LeftWing.y;
        this.RightThreeQuarter.xRot = this.LeftThreeQuarter.xRot;
        this.RightThreeQuarter.zRot = -this.LeftThreeQuarter.zRot;
        this.RightTwoQuarter.xRot = this.LeftTwoQuarter.xRot;
        this.RightOneQuarter.xRot = this.LeftOneQuarter.xRot;
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
        this.RightWing.render(stack, consumer, light, overlay, color);
        this.LeftWing.render(stack, consumer, light, overlay, color);
    }
}

