/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.blocks.entity.AlterationCatalystBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class AlterationCatalystRenderer
implements BlockEntityRenderer<AlterationCatalystBlockEntity> {
    private final ItemRenderer itemRenderer;

    public AlterationCatalystRenderer(BlockEntityRendererProvider.Context pContext) {
        this.itemRenderer = pContext.getItemRenderer();
    }

    public void render(AlterationCatalystBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        ItemStack itemstack = entity.getTheItem();
        int i = (int)entity.getBlockPos().asLong();
        if (itemstack != ItemStack.EMPTY) {
            stack.pushPose();
            double yOffset = entity.getTheItem().getItem() instanceof BlockItem ? 1.0 : 0.95;
            stack.translate(0.5, yOffset, 0.5);
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            stack.mulPose(Axis.ZP.rotationDegrees(entity.rotationDegrees));
            stack.scale(0.25f, 0.25f, 0.25f);
            this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, stack, buffers, entity.getLevel(), i);
            stack.popPose();
        }
        VertexConsumer consumer = buffers.getBuffer(RenderType.endPortal());
        Matrix4f matrix4f = stack.last().pose();
        this.renderVoidFace(matrix4f, consumer, 0.41f, 0.59f, 0.9425f, 0.9425f);
        this.renderVoidFace(matrix4f, consumer, 0.59f, 0.75f, 0.9425f, 0.875f);
        this.renderVoidFace(matrix4f, consumer, 0.75f, 0.875f, 0.875f, 0.75f);
        this.renderVoidFace(matrix4f, consumer, 0.875f, 0.94f, 0.75f, 0.595f);
        this.renderVoidFace(matrix4f, consumer, 0.94f, 0.94f, 0.595f, 0.41f);
        this.renderVoidFace(matrix4f, consumer, 0.94f, 0.875f, 0.41f, 0.25f);
        this.renderVoidFace(matrix4f, consumer, 0.875f, 0.75f, 0.25f, 0.125f);
        this.renderVoidFace(matrix4f, consumer, 0.75f, 0.59f, 0.125f, 0.058f);
        this.renderVoidFace(matrix4f, consumer, 0.59f, 0.41f, 0.0575f, 0.0575f);
        this.renderVoidFace(matrix4f, consumer, 0.41f, 0.25f, 0.0575f, 0.125f);
        this.renderVoidFace(matrix4f, consumer, 0.25f, 0.125f, 0.125f, 0.25f);
        this.renderVoidFace(matrix4f, consumer, 0.125f, 0.0575f, 0.25f, 0.41f);
        this.renderVoidFace(matrix4f, consumer, 0.0575f, 0.0575f, 0.41f, 0.59f);
        this.renderVoidFace(matrix4f, consumer, 0.0575f, 0.125f, 0.59f, 0.75f);
        this.renderVoidFace(matrix4f, consumer, 0.125f, 0.25f, 0.75f, 0.875f);
        this.renderVoidFace(matrix4f, consumer, 0.25f, 0.41f, 0.875f, 0.9425f);
    }

    private void renderVoidFace(Matrix4f pose, VertexConsumer consumer, float x0, float x1, float z0, float z1) {
        consumer.addVertex(pose, x0, 0.325f, z0);
        consumer.addVertex(pose, x1, 0.325f, z1);
        consumer.addVertex(pose, x1, 0.55f, z1);
        consumer.addVertex(pose, x0, 0.55f, z0);
    }
}

