/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.blocks.DisplayNotchBlock;
import com.bigdious.risus.blocks.entity.DisplayNotchBlockEntity;
import com.bigdious.risus.client.render.AnimationRenderHelper;
import com.bigdious.risus.config.RisusConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class DisplayNotchRenderer
implements BlockEntityRenderer<DisplayNotchBlockEntity> {
    private final ItemRenderer itemRenderer;

    public DisplayNotchRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    private int getLightVal(DisplayNotchBlockEntity entity, int regularLightVal) {
        return (Boolean)entity.getBlockState().getValue((Property)DisplayNotchBlock.GLOWING) != false ? 0xF000F0 : regularLightVal;
    }

    public void render(DisplayNotchBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        ItemStack itemstack = entity.getTheItem();
        stack.pushPose();
        boolean stand = entity.stand;
        boolean elevate = (Boolean)entity.getBlockState().getValue((Property)DisplayNotchBlock.ELEVATE);
        Direction dir = (Direction)entity.getBlockState().getValue((Property)DisplayNotchBlock.FACING);
        double offset = elevate ? (stand ? -0.25 : -0.3) : (stand ? 0.001 : -0.4675);
        stack.translate(offset * (double)dir.getStepX() + 0.5, offset * (double)dir.getStepY() + 0.5, offset * (double)dir.getStepZ() + 0.5);
        float rotation = (float)((Integer)entity.getBlockState().getValue((Property)DisplayNotchBlock.ROTATION)).intValue() * 22.5f * ((float)Math.PI / 180);
        stack.mulPose(dir.getRotation().rotateX(stand ? 0.0f : -1.5707964f).rotateY(stand ? -rotation : (float)Math.PI).rotateZ(stand ? 0.0f : rotation));
        if (RisusConfig.spinningSource == RisusConfig.SpinningSource.SIGNAL && entity.getLevel().hasNeighborSignal(entity.getBlockPos()) || entity.shouldRotate) {
            if (stand) {
                stack.mulPose(Axis.YP.rotationDegrees((float)(AnimationRenderHelper.rotation * 2)));
            } else {
                stack.mulPose(Axis.ZP.rotationDegrees((float)(AnimationRenderHelper.rotation * 2)));
            }
        }
        if (!itemstack.isEmpty() && itemstack != null && itemstack == entity.getTheItem()) {
            int k = this.getLightVal(entity, light);
            this.itemRenderer.renderStatic(itemstack, ItemDisplayContext.FIXED, k, OverlayTexture.NO_OVERLAY, stack, buffers, entity.getLevel(), (int)entity.getBlockPos().asLong());
        }
        stack.popPose();
    }
}

