/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.Risus;
import com.bigdious.risus.client.model.entity.GutsBoatModel;
import com.bigdious.risus.entity.RisusBoat;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class RisusBoatRenderer
extends EntityRenderer<RisusBoat> {
    private final Map<RisusBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public RisusBoatRenderer(EntityRendererProvider.Context context, boolean guts) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(RisusBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)RisusBoatRenderer.getTextureLocation(type, guts)), (Object)this.createBoatModel(context, (RisusBoat.Type)((Object)type), guts))));
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(Risus.prefix(path), model);
    }

    public static ModelLayerLocation createBoatModelName(RisusBoat.Type pType) {
        return RisusBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createGutsBoatModelName(RisusBoat.Type type) {
        return RisusBoatRenderer.createLocation("guts_boat/" + type.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, RisusBoat.Type type, boolean guts) {
        ModelLayerLocation modellayerlocation = guts ? RisusBoatRenderer.createGutsBoatModelName(type) : RisusBoatRenderer.createBoatModelName(type);
        ModelPart modelpart = context.bakeLayer(modellayerlocation);
        return guts ? new GutsBoatModel(modelpart) : new BoatModel(context.bakeLayer(modellayerlocation));
    }

    private static String getTextureLocation(RisusBoat.Type type, boolean guts) {
        return guts ? "textures/entity/guts_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(RisusBoat entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float bubbleAngle;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.375, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        float f = (float)entity.getHurtTime() - partialTicks;
        float f1 = entity.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(bubbleAngle = entity.getBubbleAngle(partialTicks) * ((float)Math.PI / 360)), (float)0.0f)) {
            float sin = Mth.sin((float)bubbleAngle);
            poseStack.mulPose(new Quaternionf(sin, 0.0f, sin, Mth.cos((float)bubbleAngle)));
        }
        Pair<ResourceLocation, BoatModel> boatResources = this.boatResources.get((Object)entity.getRisusBoatType());
        ResourceLocation texture = (ResourceLocation)boatResources.getFirst();
        BoatModel boat = (BoatModel)boatResources.getSecond();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        boat.setupAnim((Boat)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(boat.renderType(texture));
        boat.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        if (!entity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = bufferSource.getBuffer(RenderType.waterMask());
            boat.waterPatch().render(poseStack, vertexconsumer1, packedLight, OverlayTexture.NO_OVERLAY);
        }
        poseStack.popPose();
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(RisusBoat entity) {
        return (ResourceLocation)this.boatResources.get((Object)entity.getRisusBoatType()).getFirst();
    }
}

