/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.blocks.DepthVaseBlock;
import com.bigdious.risus.blocks.entity.DepthVaseBlockEntity;
import com.bigdious.risus.init.RisusBlocks;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class RisusSpecialItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final DepthVaseBlockEntity vase = new DepthVaseBlockEntity(BlockPos.ZERO, ((Block)RisusBlocks.DEPTH_VASE.get()).defaultBlockState());
    public static final Supplier<RisusSpecialItemRenderer> INSTANCE = Suppliers.memoize(RisusSpecialItemRenderer::new);
    public static final IClientItemExtensions CLIENT_ITEM_EXTENSION = (IClientItemExtensions)Util.make(() -> new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return INSTANCE.get();
        }
    });

    private RisusSpecialItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext context, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            Minecraft minecraft = Minecraft.getInstance();
            if (block instanceof DepthVaseBlock) {
                minecraft.getBlockEntityRenderDispatcher().renderItem((BlockEntity)this.vase, stack, buffer, light, overlay);
            }
        }
    }
}

