/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render;

import com.bigdious.risus.Risus;
import com.bigdious.risus.client.RisusModelLayers;
import com.bigdious.risus.client.model.entity.ThrownAxeModel;
import com.bigdious.risus.entity.projectile.ThrownAxe;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ThrownAxeRenderer
extends EntityRenderer<ThrownAxe> {
    public static final ResourceLocation AXE_LOCATION = Risus.prefix("textures/entity/crescent_disaster.png");
    public static final ResourceLocation CROISSANT_LOCATION = Risus.prefix("textures/entity/croissant_disaster.png");
    private final ThrownAxeModel model;

    public ThrownAxeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ThrownAxeModel(context.bakeLayer(RisusModelLayers.THROWN_AXE));
    }

    public void render(ThrownAxe axe, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)axe.yRotO, (float)axe.getYRot())));
        stack.translate(0.0, -0.5, 0.0);
        stack.translate(0.0, 0.65, 0.0);
        stack.scale(1.0f, -1.0f, -1.0f);
        stack.mulPose(Axis.XP.rotationDegrees(axe.shouldSpin() ? (float)axe.spinTickCount * 20.0f : 55.0f));
        stack.translate(0.0, -0.65, 0.0);
        VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)this.model.renderType(this.getTextureLocation(axe)), (boolean)false, (boolean)axe.isFoil());
        this.model.renderToBuffer(stack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        stack.popPose();
        super.render((Entity)axe, yaw, partialTicks, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(ThrownAxe axe) {
        return axe.isCroissant() ? CROISSANT_LOCATION : AXE_LOCATION;
    }
}

