/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.client.render.player;

import com.bigdious.risus.client.RisusModelLayers;
import com.bigdious.risus.client.model.entity.player.LeftHandPlayerModel;
import com.bigdious.risus.client.render.player.HandAnimHelper;
import com.bigdious.risus.init.RisusItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HandOfGreedLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M>
implements HandAnimHelper {
    public static final RenderType LEFT_RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"textures/entity/player/left_hand_of_greed.png"));
    public final LeftHandPlayerModel model = new LeftHandPlayerModel(Minecraft.getInstance().getEntityModels().bakeLayer(RisusModelLayers.LEFT_HAND_OF_GREED));

    public HandOfGreedLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T parent, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = parent.getItemBySlot(EquipmentSlot.OFFHAND);
        if (this.shouldRender(itemstack)) {
            boolean slim = false;
            EntityModel entityModel = this.getParentModel();
            if (entityModel instanceof PlayerModel) {
                PlayerModel player = (PlayerModel)entityModel;
                slim = player.slim;
            }
            this.model.setupArmSize(slim);
            this.model.setupAnim((LivingEntity)parent, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.prepareMobModel((LivingEntity)parent, limbSwing, limbSwingAmount, partialTicks);
            HandAnimHelper.followBodyRotations(parent, new HumanoidModel[]{this.model});
            VertexConsumer vertexConsumer = buffer.getBuffer(LEFT_RENDER_TYPE);
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }

    public boolean shouldRender(ItemStack stack) {
        return stack.is(RisusItems.HAND_OF_GREED);
    }
}

