/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.compat;

import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.inventory.recipe.AlterationRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AlterationCategory
implements IRecipeCategory<AlterationRecipe> {
    public static final RecipeType<AlterationRecipe> ALTERATION = RecipeType.create((String)"risus", (String)"alteration", AlterationRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public AlterationCategory(IGuiHelper helper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"textures/gui/alteration_gui.png");
        this.background = helper.createDrawable(location, 0, 0, 116, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)RisusBlocks.ALTERATION_CATALYST.asItem().getDefaultInstance());
        this.localizedName = Component.translatable((String)"gui.risus.alteration_jei");
    }

    public RecipeType<AlterationRecipe> getRecipeType() {
        return ALTERATION;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(AlterationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.background.draw(graphics, 0, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlterationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).addIngredients(recipe.input());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 81, 19).addItemStack(new ItemStack((ItemLike)recipe.result().getItem()));
    }
}

