/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.data;

import com.bigdious.risus.Risus;
import com.bigdious.risus.config.RisusConfig;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusItems;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "risus", existingFileHelper);
    }

    protected void registerModels() {
        this.toBlockModel((Block)RisusBlocks.ALTERATION_CATALYST.get(), Risus.prefix("block/alteration_catalyst_inventory"));
        this.toBlock((Block)RisusBlocks.ANGEL_ALTAR.get());
        this.toBlock((Block)RisusBlocks.FLESHY_SPAWNER.get());
        this.toBlock((Block)RisusBlocks.INACTIVE_HOLDER.get());
        this.toBlock((Block)RisusBlocks.DISPLAY_NOTCH.get());
        this.toBlock((Block)RisusBlocks.ORGANIC_MATTER_BLOCK.get());
        this.toBlock((Block)RisusBlocks.COPPER_AMALGAM.get());
        this.toBlock((Block)RisusBlocks.EXPOSED_COPPER_AMALGAM.get());
        this.toBlock((Block)RisusBlocks.WEATHERED_COPPER_AMALGAM.get());
        this.toBlock((Block)RisusBlocks.OXIDIZED_COPPER_AMALGAM.get());
        this.toBlock((Block)RisusBlocks.OXIDIZED_COPPER_AMALGAM.get());
        this.toBlockModel((Block)RisusBlocks.WAXED_COPPER_AMALGAM.get(), Risus.prefix("block/copper_amalgam"));
        this.toBlockModel((Block)RisusBlocks.WAXED_EXPOSED_COPPER_AMALGAM.get(), Risus.prefix("block/exposed_copper_amalgam"));
        this.toBlockModel((Block)RisusBlocks.WAXED_WEATHERED_COPPER_AMALGAM.get(), Risus.prefix("block/weathered_copper_amalgam"));
        this.toBlockModel((Block)RisusBlocks.WAXED_OXIDIZED_COPPER_AMALGAM.get(), Risus.prefix("block/oxidized_copper_amalgam"));
        this.toBlock((Block)RisusBlocks.LAUGHING_STALK.get());
        this.toBlock((Block)RisusBlocks.ASHEN_REMAINS.get());
        this.toBlockModel((Block)RisusBlocks.SMILING_REMAINS.get(), Risus.prefix("block/smiling_remains/1"));
        this.toBlock((Block)RisusBlocks.LAUGHING_OBSIDIAN.get());
        this.toBlock((Block)RisusBlocks.ENGRAVED_BASALT.get());
        this.toBlock((Block)RisusBlocks.LIGHT_EXCREMENT.get());
        this.toBlock((Block)RisusBlocks.MAW_GUTS.get());
        this.toBlock((Block)RisusBlocks.GLUTTONY_SCALEPLATE.get());
        this.toBlockModel((Block)RisusBlocks.IMITATION_SCALEPLATE.get(), Risus.prefix("block/gluttony_scaleplate"));
        this.toBlock((Block)RisusBlocks.FLOWERING_IMITATION_SCALEPLATE.get());
        this.toBlock((Block)RisusBlocks.BUDDING_IMITATION_SCALEPLATE.get());
        this.toBlock((Block)RisusBlocks.FLATTENED_SCALES_BLOCK.get());
        this.toBlockModel((Block)RisusBlocks.FLATTENED_IMITATION_SCALES_BLOCK.get(), Risus.prefix("block/flattened_scales_block"));
        this.toBlock((Block)RisusBlocks.IMITATION_SCALES_BLOCK_STAIRS.get());
        this.toBlock((Block)RisusBlocks.IMITATION_SCALES_BLOCK_SLAB.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.IMITATION_SCALES_BLOCK_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", Risus.prefix("block/flat_scales_block_side"));
        this.toBlock((Block)RisusBlocks.CRYSTALLIZED_BONDS.get());
        this.toBlock((Block)RisusBlocks.MIRAGE_GRASS_BLOCK.get());
        this.toBlock((Block)RisusBlocks.MIRAGE_SAND.get());
        this.toBlock((Block)RisusBlocks.MIRAGE_NETHERRACK.get());
        this.toBlock((Block)RisusBlocks.MIRAGE_END_STONE.get());
        this.toBlockModel((Block)RisusBlocks.BLOODWEAVE.get(), Risus.prefix("block/bloodweave_core"));
        this.toBlock((Block)RisusBlocks.SCAB.get());
        this.toBlock((Block)RisusBlocks.COAGULATED_BLOOD_BLOCK.get());
        this.toBlock((Block)RisusBlocks.WEAVER_NEST.get());
        this.toBlock((Block)RisusBlocks.BOND_GLASS.get());
        this.toBlock((Block)RisusBlocks.CONTAINMENT_GLASS.get());
        this.toBlock((Block)RisusBlocks.BONDKNOT_LOG.get());
        this.toBlock((Block)RisusBlocks.BONDKNOT_WOOD.get());
        this.toBlockModel((Block)RisusBlocks.POPPING_BONDKNOT_LOG.get(), Risus.prefix("block/popping_bondknot_log_north"));
        this.toBlockModel((Block)RisusBlocks.POPPING_BONDKNOT_WOOD.get(), Risus.prefix("block/popping_bondknot_wood_north"));
        this.toBlock((Block)RisusBlocks.STRIPPED_BONDKNOT_LOG.get());
        this.toBlock((Block)RisusBlocks.STRIPPED_BONDKNOT_WOOD.get());
        this.toBlock((Block)RisusBlocks.BONDKNOT_PLANKS.get());
        this.toBlock((Block)RisusBlocks.BONDKNOT_SLAB.get());
        this.toBlock((Block)RisusBlocks.BONDKNOT_STAIRS.get());
        this.toBlock((Block)RisusBlocks.BONDKNOT_FENCE_GATE.get());
        this.toBlock((Block)RisusBlocks.BONDKNOT_PRESSURE_PLATE.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.BONDKNOT_FENCE.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/fence_inventory")))).texture("texture", Risus.prefix("block/bondknot_planks"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.BONDKNOT_BUTTON.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/button_inventory")))).texture("texture", Risus.prefix("block/bondknot_planks"));
        this.toBlockModel((Block)RisusBlocks.BONDKNOT_TRAPDOOR.get(), Risus.prefix("block/bondknot_trapdoor_bottom"));
        this.generated(RisusBlocks.BONDKNOT_DOOR.getId().getPath(), Risus.prefix("item/bondknot_door"));
        this.generated(RisusBlocks.BONDKNOT_SIGN.getId().getPath(), Risus.prefix("item/bondknot_sign"));
        this.generated(RisusBlocks.BONDKNOT_HANGING_SIGN.getId().getPath(), Risus.prefix("item/bondknot_hanging_sign"));
        this.toBlock((Block)RisusBlocks.BABY_RIBCAGE.get());
        this.toBlock((Block)RisusBlocks.RIBCAGE.get());
        this.toBlock((Block)RisusBlocks.GRIMSTONE.get());
        this.toBlock((Block)RisusBlocks.GRIMSTONE_BRICKS.get());
        this.toBlock((Block)RisusBlocks.ACTIVE_GRIMSTONE.get());
        this.toBlock((Block)RisusBlocks.CRACKED_GRIMSTONE_BRICKS.get());
        this.toBlock((Block)RisusBlocks.GRIMSTONE_SLAB.get());
        this.toBlock((Block)RisusBlocks.GRIMSTONE_BRICKS_SLAB.get());
        this.toBlock((Block)RisusBlocks.POLISHED_GRIMSTONE_SLAB.get());
        this.toBlock((Block)RisusBlocks.GRIMSTONE_STAIRS.get());
        this.toBlock((Block)RisusBlocks.GRIMSTONE_BRICKS_STAIRS.get());
        this.toBlock((Block)RisusBlocks.POLISHED_GRIMSTONE_STAIRS.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.GRIMSTONE_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", Risus.prefix("block/grimstone"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.GRIMSTONE_BRICKS_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", Risus.prefix("block/grimstone_bricks"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.POLISHED_GRIMSTONE_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", Risus.prefix("block/polished_grimstone"));
        this.toBlock((Block)RisusBlocks.CHISELED_GRIMSTONE.get());
        this.toBlock((Block)RisusBlocks.LINEAR_RITUAL_BLOCK.get());
        this.toBlockModel((Block)RisusBlocks.CURVED_RITUAL_BLOCK.get(), Risus.prefix("block/curved_ritual_block"));
        this.toBlock((Block)RisusBlocks.POLISHED_GRIMSTONE.get());
        this.toBlock((Block)RisusBlocks.BURNT_HYPHAE.get());
        this.toBlock((Block)RisusBlocks.ZIT.get());
        this.toBlock((Block)RisusBlocks.TISSUE.get());
        this.toBlockModel((Block)RisusBlocks.ROTTING_TISSUE.get(), Risus.prefix("block/tissue/rotting_tissue_post"));
        this.toBlockModel((Block)RisusBlocks.DECOMPOSING_TISSUE.get(), Risus.prefix("block/tissue/decomposing_tissue_post"));
        this.toBlockModel((Block)RisusBlocks.DECAYING_TISSUE.get(), Risus.prefix("block/tissue/decaying_tissue_post"));
        this.toBlock((Block)RisusBlocks.LIVING_TISSUE.get());
        this.toBlockModel((Block)RisusBlocks.ROTTED_TISSUE.get(), Risus.prefix("block/tissue/rotting_tissue_post"));
        this.toBlockModel((Block)RisusBlocks.DECOMPOSED_TISSUE.get(), Risus.prefix("block/tissue/decomposing_tissue_post"));
        this.toBlockModel((Block)RisusBlocks.DECAYED_TISSUE.get(), Risus.prefix("block/tissue/decaying_tissue_post"));
        this.toBlock((Block)RisusBlocks.TISSUE_STAIRS.get());
        this.toBlock((Block)RisusBlocks.TISSUE_SLAB.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.TISSUE_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", Risus.prefix("block/tissue"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.BONE_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", ResourceLocation.withDefaultNamespace((String)"block/bone_block_side"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.FOSSIL_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", Risus.prefix("block/fossil_side"));
        this.toBlock((Block)RisusBlocks.BONE_STAIRS.get());
        this.toBlock((Block)RisusBlocks.BONE_SLAB.get());
        this.toBlock((Block)RisusBlocks.FULL_BONE_STAIRS.get());
        this.toBlock((Block)RisusBlocks.FULL_BONE_SLAB.get());
        this.toBlock((Block)RisusBlocks.FULL_BONE_BLOCK.get());
        this.toBlock((Block)RisusBlocks.BLOODY_SPONGE.get());
        this.toBlock((Block)RisusBlocks.FOSSIL.get());
        this.toBlock((Block)RisusBlocks.FOSSIL_STAIRS.get());
        this.toBlock((Block)RisusBlocks.FOSSIL_SLAB.get());
        this.toBlock((Block)RisusBlocks.FULL_FOSSIL_STAIRS.get());
        this.toBlock((Block)RisusBlocks.FULL_FOSSIL_SLAB.get());
        this.toBlock((Block)RisusBlocks.FULL_FOSSIL.get());
        this.toBlock((Block)RisusBlocks.BLOODY_SPONGE.get());
        this.toBlockModel((Block)RisusBlocks.EYE_ENDER.get(), Risus.prefix("block/eye/ender"));
        this.toBlockModel((Block)RisusBlocks.EYE_BLEACHED.get(), Risus.prefix("block/eye/bleached"));
        this.toBlockModel((Block)RisusBlocks.EYE_BLOODSHOT.get(), Risus.prefix("block/eye/bloodshot"));
        this.toBlockModel((Block)RisusBlocks.EYE_EMERALD.get(), Risus.prefix("block/eye/emerald"));
        this.toBlockModel((Block)RisusBlocks.EYE_GOLDEN.get(), Risus.prefix("block/eye/golden"));
        this.toBlockModel((Block)RisusBlocks.EYE_ENDER_GLOWING.get(), Risus.prefix("block/eye/ender_glowing"));
        this.toBlockModel((Block)RisusBlocks.EYE_BLEACHED_GLOWING.get(), Risus.prefix("block/eye/bleached_glowing"));
        this.toBlockModel((Block)RisusBlocks.EYE_BLOODSHOT_GLOWING.get(), Risus.prefix("block/eye/bloodshot_glowing"));
        this.toBlockModel((Block)RisusBlocks.EYE_EMERALD_GLOWING.get(), Risus.prefix("block/eye/emerald_glowing"));
        this.toBlockModel((Block)RisusBlocks.EYE_GOLDEN_GLOWING.get(), Risus.prefix("block/eye/golden_glowing"));
        this.toBlock((Block)RisusBlocks.SKIN.get());
        this.toBlock((Block)RisusBlocks.FLESHY_SKIN.get());
        this.toBlock((Block)RisusBlocks.CURVED_FLESHY_SKIN.get());
        this.toBlock((Block)RisusBlocks.HAIRY_SKIN.get());
        this.toBlock((Block)RisusBlocks.HAIRY_FLESHY_SKIN.get());
        this.toBlock((Block)RisusBlocks.HAIRY_CURVED_FLESHY_SKIN.get());
        this.toBlock((Block)RisusBlocks.TALL_HAIR.get());
        this.toBlock((Block)RisusBlocks.BUNDLE_OF_HAIR.get());
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RisusBlocks.BONE_WALL.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"block/wall_inventory")))).texture("wall", ResourceLocation.withDefaultNamespace((String)"block/bone_block_side"));
        this.singleTex((ItemLike)RisusItems.RESEARCHERS_NOTES);
        this.singleTex((ItemLike)RisusItems.MUSIC_DISC_RAK);
        this.singleTex((ItemLike)RisusItems.MUSIC_DISC_REGN);
        this.singleTex((ItemLike)RisusItems.MUSIC_DISC_FEIGR);
        this.singleTex((ItemLike)RisusItems.MUSIC_DISC_MORK);
        this.singleTex((ItemLike)RisusItems.ANGEL_WINGS).override().predicate(Risus.prefix("broken"), 1.0f).model((ModelFile)this.singleTex("angel_wings_broken")).end().override().predicate(Risus.prefix("ashen"), 1.0f).model((ModelFile)this.singleTex("ashen_wings")).end().override().predicate(Risus.prefix("ashen"), 1.0f).predicate(Risus.prefix("broken"), 1.0f).model((ModelFile)this.singleTex("ashen_wings_broken"));
        this.singleTex((ItemLike)RisusItems.ESSENCE_OF_GLUTTONY);
        this.singleTex((ItemLike)RisusItems.ESSENCE_OF_GREED);
        this.singleTex((ItemLike)RisusItems.ESSENCE_OF_SLOTH);
        this.singleTex((ItemLike)RisusItems.ESSENCE_OF_LUST);
        this.singleTex((ItemLike)RisusItems.ESSENCE_OF_MELANCHOLY);
        this.singleTex((ItemLike)RisusItems.EMBODIMENT_OF_COURTSHIP);
        this.singleTex((ItemLike)RisusItems.EMBODIMENT_OF_INTIMACY);
        this.singleTex((ItemLike)RisusItems.EMBODIMENT_OF_DEVOTION);
        this.singleTex((ItemLike)RisusItems.BLOOD_FEATHER);
        this.singleTex((ItemLike)RisusItems.BLOOD_BUCKET);
        this.singleTex((ItemLike)RisusItems.BONDKNOT_BOAT);
        this.singleTex((ItemLike)RisusItems.GUTS_BOAT);
        this.singleTex((ItemLike)RisusItems.CONCENTRATION_CORE);
        this.singleTex((ItemLike)RisusItems.CRYSTALLIZED_BOND);
        this.singleTex((ItemLike)RisusItems.GLUTTONY_SCALES);
        this.singleTex((ItemLike)RisusItems.GUILTY_APPLE);
        this.singleTex((ItemLike)RisusItems.MEMORY_CORE);
        this.singleTex((ItemLike)RisusItems.ORGANIC_MATTER);
        this.trimmedArmor(RisusItems.SKIN_HELMET);
        this.trimmedArmor(RisusItems.SKIN_CHESTPLATE);
        this.trimmedArmor(RisusItems.SKIN_LEGGINGS);
        this.trimmedArmor(RisusItems.SKIN_BOOTS);
        this.trimmedArmor(RisusItems.THREADERS_OF_THE_FIRMAMENT);
        this.singleTex((ItemLike)RisusItems.SMILE_PATTERN);
        this.singleTex((ItemLike)RisusItems.DIVINITY_PATTERN);
        this.singleTex((ItemLike)RisusItems.TREE_PATTERN);
        this.singleTex((ItemLike)RisusItems.ROSE_PATTERN);
        this.singleTex((ItemLike)RisusItems.STALKER_EYE);
        this.singleTex((ItemLike)RisusItems.EYE_SANDWICH);
        this.singleTex((ItemLike)RisusItems.EGG_SAC);
        this.singleTex((ItemLike)RisusItems.SACRIFICE_CATALYST);
        this.singleTex((ItemLike)RisusItems.TOTEM_OF_UNYIELDING);
        ItemModelBuilder crescentNamed = this.handheldItem(RisusItems.CRESCENT_DISASTER, "_named", (ModelFile)this.getExistingFile(Risus.prefix("item/base_axe_model")), Risus.prefix("item/croissant_disaster"), Risus.prefix("item/croissant_disaster_item"), "axe");
        ItemModelBuilder crescentCharged = this.handheldItem(RisusItems.CRESCENT_DISASTER, "_charged", (ModelFile)this.getExistingFile(Risus.prefix("item/base_axe_model")), Risus.prefix("item/crescent_disaster_pulled"), Risus.prefix("item/crescent_disaster_item_pulled"), "axe");
        ItemModelBuilder croissantCharged = this.handheldItem(RisusItems.CRESCENT_DISASTER, "_named_charged", (ModelFile)this.getExistingFile(Risus.prefix("item/base_axe_model")), Risus.prefix("item/croissant_disaster_pulled"), Risus.prefix("item/croissant_disaster_item_pulled"), "axe");
        this.handheldItem(RisusItems.CRESCENT_DISASTER, (ModelFile)this.getExistingFile(Risus.prefix("item/base_axe_model")), Risus.prefix("item/crescent_disaster"), Risus.prefix("item/crescent_disaster_item"), "axe").override().predicate(Risus.prefix("croissant"), 1.0f).model((ModelFile)crescentNamed).end().override().predicate(Risus.prefix("charged"), 1.0f).model((ModelFile)crescentCharged).end().override().predicate(Risus.prefix("charged"), 1.0f).predicate(Risus.prefix("croissant"), 1.0f).model((ModelFile)croissantCharged).end();
        this.handheldItem(RisusItems.BOOMSTICK, (ModelFile)this.getExistingFile(Risus.prefix("item/boomstick_held")), Risus.prefix("item/boomstick"), Risus.prefix("item/boomstick_item"), "boomstick");
        this.handheldItem(RisusItems.SCYTHE, (ModelFile)this.withExistingParent("scythe_held", Risus.prefix("item/template_held_scythe")), Risus.prefix("item/scythe"), Risus.prefix("item/scythe_item"), "texture");
        ItemModelBuilder noAnimSoulScythe = this.handheldItem(RisusItems.SOUL_SCYTHE, (ModelFile)this.withExistingParent("soul_scythe_held", Risus.prefix("item/template_held_scythe_no_anim")), Risus.prefix("item/soul_scythe"), Risus.prefix("item/soul_scythe_item"), "texture");
        this.handheldItem(RisusItems.SOUL_SCYTHE, (ModelFile)this.withExistingParent("soul_scythe_held", Risus.prefix("item/template_held_scythe")), Risus.prefix("item/soul_scythe"), Risus.prefix("item/soul_scythe_item"), "texture").override().predicate(Risus.prefix("no_anim"), 1.0f).model((ModelFile)noAnimSoulScythe).end();
        ItemModelBuilder noAnimFireScythe = this.handheldItem(RisusItems.FIRE_SCYTHE, (ModelFile)this.withExistingParent("fire_scythe_held", Risus.prefix("item/template_held_scythe_no_anim")), Risus.prefix("item/fire_scythe"), Risus.prefix("item/fire_scythe_item"), "texture");
        this.handheldItem(RisusItems.FIRE_SCYTHE, (ModelFile)this.withExistingParent("fire_scythe_held", Risus.prefix("item/template_held_scythe")), Risus.prefix("item/fire_scythe"), Risus.prefix("item/fire_scythe_item"), "texture").override().predicate(Risus.prefix("no_anim"), 1.0f).model((ModelFile)noAnimFireScythe).end();
        ItemModelBuilder noAnimCindergleeScythe = this.handheldItem(RisusItems.CINDERGLEE_SCYTHE, (ModelFile)this.withExistingParent("cinderglee_scythe_held", Risus.prefix("item/template_held_scythe_no_anim")), Risus.prefix("item/cinderglee_scythe"), Risus.prefix("item/cinderglee_scythe_item"), "texture");
        this.handheldItem(RisusItems.CINDERGLEE_SCYTHE, (ModelFile)this.withExistingParent("cinderglee_scythe_held", Risus.prefix("item/template_held_scythe")), Risus.prefix("item/cinderglee_scythe"), Risus.prefix("item/cinderglee_scythe_item"), "texture").override().predicate(Risus.prefix("no_anim"), 1.0f).model((ModelFile)noAnimCindergleeScythe).end();
        ItemModelBuilder bladeCharged = this.handheldItem(RisusItems.THOUSAND_BLADE, "_charged", (ModelFile)this.getExistingFile(Risus.prefix("item/thousand_blade_held")), Risus.prefix("item/intact_thousand_blade_pulled"), Risus.prefix("item/thousand_blade_item_pulled"), "thousand_blade");
        this.handheldItem(RisusItems.THOUSAND_BLADE, (ModelFile)this.getExistingFile(Risus.prefix("item/thousand_blade_held")), Risus.prefix("item/intact_thousand_blade"), Risus.prefix("item/thousand_blade_item"), "thousand_blade").override().predicate(Risus.prefix("charged"), 1.0f).model((ModelFile)bladeCharged).end();
        this.handheldItem(RisusItems.UNAWAKENED_VESSEL, (ModelFile)this.getExistingFile(Risus.prefix("item/base_axe_model")), Risus.prefix("entity/unawakened_vessel"), Risus.prefix("item/unawakened_vessel"), "axe");
        this.handheldItem(RisusItems.HAND_OF_GREED, (ModelFile)this.getExistingFile(Risus.prefix("item/hand_of_greed_held")), Risus.prefix("item/hand_of_greed"), Risus.prefix("item/hand_of_greed_item"), "hand_of_greed");
        this.handheldItem(RisusItems.TOOTHKNOCKER, (ModelFile)this.getExistingFile(Risus.prefix("item/toothknocker_held")), Risus.prefix("item/toothknocker"), Risus.prefix("item/toothknocker_item"), "texture");
        this.handheldItem(RisusItems.GOLD_FIST, (ModelFile)this.getExistingFile(Risus.prefix("item/gold_fist_held")), Risus.prefix("item/gold_fist"), Risus.prefix("item/gold_fist_item"), "texture");
        this.singleTex((ItemLike)RisusItems.SMILE);
        this.singleTex((ItemLike)RisusBlocks.JOYFLAME_CAMPFIRE);
        this.singleTex((ItemLike)RisusBlocks.JOYFLAME_LANTERN);
        this.singleTex((ItemLike)RisusItems.JOYFLAME_TORCH);
        this.singleTex((ItemLike)RisusBlocks.HEART_TRANSPLANT);
        this.singleTex((ItemLike)RisusItems.VEINS);
        this.singleTex((ItemLike)RisusBlocks.BIG_CHAIN);
        this.generatedRenderType(RisusBlocks.SPREADING_REMAINS.getId().getPath(), "minecraft:translucent", Risus.prefix("item/spreading_remains"));
        this.generatedRenderType(RisusBlocks.ASHEN_SPIRE.getId().getPath(), "minecraft:cutout", Risus.prefix("block/ashen_spire_top"));
        this.singleTex((ItemLike)RisusItems.MEMORY1_ITEM);
        this.singleTex((ItemLike)RisusBlocks.REGEN_ROSE);
        this.singleTex((ItemLike)RisusItems.LIGHT_DEVOURER);
        this.singleTex((ItemLike)RisusItems.ENDLESS_PEARL);
        this.singleTex((ItemLike)RisusBlocks.TEETH);
        this.singleTex((ItemLike)RisusBlocks.NEURON_HEAD.asItem());
        this.singleTex((ItemLike)RisusItems.HAIR_FOLLICLES);
        for (DeferredHolder item : RisusEntities.SPAWN_EGGS.getEntries()) {
            if (!(item.get() instanceof SpawnEggItem)) continue;
            ((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg")));
        }
    }

    private void toBlock(Block b) {
        this.toBlockModel(b, Risus.prefix("block/" + Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)b)).getPath()));
    }

    private void toBlockModel(Block b, ResourceLocation model) {
        this.withExistingParent(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)b)).getPath(), model);
    }

    private ItemModelBuilder generated(String name, String parent, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, parent);
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        return this.generated(name, "item/generated", layers);
    }

    private ItemModelBuilder singleTex(String texture) {
        return this.generated(texture, "item/generated", Risus.prefix("item/" + texture));
    }

    private ItemModelBuilder singleTex(ItemLike item) {
        return this.generated(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath(), "item/generated", Risus.prefix("item/" + BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath()));
    }

    private ItemModelBuilder singleTexTool(DeferredHolder<Item, Item> item) {
        return this.generated(item.getId().getPath(), "item/handheld", Risus.prefix("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder generatedRenderType(String name, @Nullable String renderType, ResourceLocation ... layers) {
        return this.buildItem(name, "item/generated", renderType, layers);
    }

    private ItemModelBuilder buildItem(String name, String parent, @Nullable String renderType, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, parent);
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        if (renderType != null) {
            builder = (ItemModelBuilder)builder.renderType(renderType);
        }
        return builder;
    }

    public String itemName(Item item) {
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item);
        if (location != null) {
            return location.getPath();
        }
        throw new IllegalStateException("Unknown item: " + item.toString());
    }

    public void nameableWeapon(Item item, String location, String renamedVariant) {
        ((ItemModelBuilder)this.withExistingParent(renamedVariant, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + renamedVariant));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).override().predicate(ResourceLocation.fromNamespaceAndPath((String)"risus", (String)"named"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + renamedVariant))).end();
    }

    private void trimmedArmor(DeferredItem<ArmorItem> armor) {
        ItemModelBuilder base = this.singleTex((ItemLike)armor);
        for (ItemModelGenerators.TrimModelData trim : ItemModelGenerators.GENERATED_TRIM_MODELS) {
            String material = trim.name();
            String name = armor.getId().getPath() + "_" + material + "_trim";
            ModelBuilder trimModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", Risus.prefix("item/" + armor.getId().getPath()))).texture("layer1", this.mcLoc("trims/items/" + ((ArmorItem)armor.get()).getType().getName() + "_trim_" + material));
            base.override().predicate(ResourceLocation.withDefaultNamespace((String)"trim_type"), trim.itemModelIndex()).model((ModelFile)trimModel).end();
        }
    }

    private ItemModelBuilder handheldItem(DeferredItem<Item> item, ModelFile heldModel, ResourceLocation heldTexture, ResourceLocation itemTexture, String textureName) {
        return this.handheldItem(item, "", heldModel, heldTexture, itemTexture, textureName);
    }

    private ItemModelBuilder handheldItem(DeferredItem<Item> item, String suffix, ModelFile heldModel, ResourceLocation heldTexture, ResourceLocation itemTexture, String textureName) {
        ItemModelBuilder heldVersion = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent(heldModel)).texture(textureName, heldTexture);
        return (ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath() + suffix, "item/handheld")).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)this.generated(String.valueOf(item.getId()) + suffix + "_base", itemTexture)).perspective(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.HEAD, (ModelBuilder)heldVersion).end();
    }

    private ItemModelBuilder handheldItemWithNoAnim(DeferredItem<Item> item, ModelFile heldModel, ModelFile heldModelNoAnim, ResourceLocation heldTexture, ResourceLocation itemTexture, String textureName) {
        ItemModelBuilder heldVersion = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent(RisusConfig.customWeaponAnims ? heldModel : heldModelNoAnim)).texture(textureName, heldTexture);
        return (ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), "item/handheld")).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)this.generated(String.valueOf(item.getId()) + "_base", itemTexture)).perspective(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (ModelBuilder)heldVersion).perspective(ItemDisplayContext.HEAD, (ModelBuilder)heldVersion).end();
    }

    public String getName() {
        return "Risus Item Models";
    }
}

