/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.dispenser;

import com.bigdious.risus.dispenser.OrganicMatterDispenseBehaviour;
import com.bigdious.risus.dispenser.ShavingDispenserBehaviour;
import com.bigdious.risus.dispenser.WaxingDispenserBehaviour;
import com.bigdious.risus.init.RisusItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class RisusDispenserBehaviours {
    public static void register() {
        DefaultDispenseItemBehavior bucketBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.getItem();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel world = source.level().getLevel();
                if (bucketitem.emptyContents(null, (Level)world, blockpos, null)) {
                    bucketitem.checkExtraContent(null, (Level)world, stack, blockpos);
                    return new ItemStack((ItemLike)Items.BUCKET);
                }
                return this.defaultBehavior.dispense(source, stack);
            }
        };
        DispenseItemBehavior cachedShearsBehavior = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.SHEARS);
        DispenseItemBehavior cachedHoneyCombBehavior = (DispenseItemBehavior)DispenserBlock.DISPENSER_REGISTRY.get(Items.HONEYCOMB);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)RisusItems.BLOOD_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
        DispenserBlock.registerBehavior(RisusItems.ORGANIC_MATTER, (DispenseItemBehavior)new OrganicMatterDispenseBehaviour());
        DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)new ShavingDispenserBehaviour(cachedShearsBehavior));
        DispenserBlock.registerBehavior((ItemLike)Items.HONEYCOMB, (DispenseItemBehavior)new WaxingDispenserBehaviour(cachedHoneyCombBehavior));
        DispenserBlock.registerProjectileBehavior(RisusItems.EGG_SAC);
    }
}

