/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.dispenser;

import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusItems;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShavingDispenserBehaviour
extends OptionalDispenseItemBehavior {
    private final DispenseItemBehavior vanillaBehavior;
    boolean fired = false;
    public static final Map<Block, Block> SHAVINGS = Map.of((Block)RisusBlocks.HAIRY_SKIN.get(), (Block)RisusBlocks.SKIN.get(), (Block)RisusBlocks.HAIRY_FLESHY_SKIN.get(), (Block)RisusBlocks.FLESHY_SKIN.get(), (Block)RisusBlocks.HAIRY_CURVED_FLESHY_SKIN.get(), (Block)RisusBlocks.CURVED_FLESHY_SKIN.get());

    public ShavingDispenserBehaviour(DispenseItemBehavior vanillaBehavior) {
        this.vanillaBehavior = vanillaBehavior;
    }

    protected ItemStack execute(BlockSource source, ItemStack stack) {
        BlockPos pos;
        ServerLevel level = source.level();
        BlockState state = level.getBlockState(pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)));
        Block checkingForBlock = state.getBlock();
        if (SHAVINGS.containsKey(checkingForBlock)) {
            level.setBlock(pos, SHAVINGS.get(checkingForBlock).withPropertiesOf(state), 3);
            ItemEntity summonedItem = (ItemEntity)EntityType.ITEM.create((Level)level);
            summonedItem.moveTo(pos.above(), 0.0f, 0.0f);
            summonedItem.setItem(RisusItems.HAIR_FOLLICLES.toStack());
            level.addFreshEntity((Entity)summonedItem);
            stack.hurtAndBreak(1, level, null, item -> {});
        }
        this.fired = true;
        return this.vanillaBehavior.dispense(source, stack);
    }

    protected void playSound(BlockSource source) {
        if (this.fired) {
            super.playSound(source);
            this.fired = false;
        } else {
            source.level().levelEvent(1001, source.pos(), 0);
        }
    }
}

