/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.advancement.HolyGroundsTrigger;
import com.bigdious.risus.entity.goals.YIncludedNearestAttackableTargetGoal;
import com.bigdious.risus.init.RisusAdvancements;
import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusFluids;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;

public class Angel
extends Monster {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.defineId(Angel.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Angel(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.xpReward = 0;
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.FOLLOW_RANGE, 60.0);
    }

    public void setCharging(boolean charging) {
        this.entityData.set(DATA_IS_CHARGING, (Object)charging);
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(DATA_IS_CHARGING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_CHARGING, (Object)false);
    }

    public boolean canSwimInFluidType(FluidType type) {
        if (type == RisusFluids.BLOOD_FLUID_TYPE.get()) {
            return false;
        }
        return super.canSwimInFluidType(type);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new AngelLookGoal(this));
        this.goalSelector.addGoal(7, (Goal)new AngelLightningAttackGoal(this));
        this.targetSelector.addGoal(1, new YIncludedNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, entity -> !entity.isInvulnerable() && !(entity instanceof ArmorStand) && !entity.getType().is(RisusTags.Entities.OFFSPRING) && !entity.getType().is(RisusTags.Entities.BELOVED)));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || source.is(RisusDamageTypes.AXED) || source.getWeaponItem() != null && (source.getWeaponItem().is(RisusTags.Items.WILLFUL_WEAPON) || source.getWeaponItem().is(RisusItems.SCYTHE) || source.getWeaponItem().is(RisusItems.FIRE_SCYTHE) || source.getWeaponItem().is(RisusItems.SOUL_SCYTHE) || source.getWeaponItem().is(RisusItems.CINDERGLEE_SCYTHE) || source.getWeaponItem().is(RisusItems.UNAWAKENED_VESSEL) || source.getWeaponItem().is(RisusItems.CRESCENT_DISASTER) || source.getWeaponItem().is(RisusItems.THOUSAND_BLADE))) {
            return super.hurt(source, Float.MAX_VALUE);
        }
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    static class AngelLookGoal
    extends Goal {
        private final Angel ophanim;

        public AngelLookGoal(Angel ophanim) {
            this.ophanim = ophanim;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return true;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.ophanim.getTarget() != null) {
                LivingEntity livingentity = this.ophanim.getTarget();
                double d1 = livingentity.getX() - this.ophanim.getX();
                double d2 = livingentity.getZ() - this.ophanim.getZ();
                this.ophanim.setYRot(-((float)Mth.atan2((double)d1, (double)d2)) * 57.295776f);
                this.ophanim.yBodyRot = this.ophanim.getYRot();
            }
        }
    }

    static class AngelLightningAttackGoal
    extends Goal {
        private final Angel angel;
        public int chargeTime;
        public int soundCD;

        public AngelLightningAttackGoal(Angel angel) {
            this.angel = angel;
        }

        public boolean canUse() {
            return this.angel.getTarget() != null && this.angel.level().getDifficulty() != Difficulty.PEACEFUL;
        }

        public void start() {
            this.chargeTime = 0;
        }

        public void stop() {
            this.angel.setCharging(false);
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.angel.getTarget();
            Level level = this.angel.level();
            if (livingentity != null && this.angel.hasLineOfSight((Entity)livingentity) && level.canSeeSky(livingentity.blockPosition())) {
                if (this.chargeTime == 1 && this.soundCD < 1) {
                    level.playSound(null, livingentity.getOnPos().above(2), (SoundEvent)RisusSoundEvents.TOLLING_BELL.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
                    this.soundCD = 29;
                }
                ++this.chargeTime;
                --this.soundCD;
                if (this.chargeTime == 30) {
                    LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
                    lightning.setPos(livingentity.getX(), livingentity.getEyeY(), livingentity.getZ());
                    level.addFreshEntity((Entity)lightning);
                    if (livingentity instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)livingentity;
                        ((HolyGroundsTrigger)((Object)RisusAdvancements.HOLY_GROUNDS.get())).trigger(sp);
                    }
                    this.chargeTime = -40;
                    this.soundCD = 0;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.angel.setCharging(this.chargeTime > 10);
        }
    }
}

