/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.entity;

import com.bigdious.risus.blocks.LightExcrementBlock;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDataComponents;
import com.bigdious.risus.init.RisusEntities;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusSoundEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class Litter
extends TamableAnimal {
    private int lightCheckInterval = 100;
    private static final EntityDataAccessor<BlockState> BLOCK = SynchedEntityData.defineId(Litter.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);

    public Litter(Level level, @Nullable Player owner) {
        super((EntityType)RisusEntities.LITTER.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.getUUID());
        }
    }

    public Litter(EntityType<Litter> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Frog.class, 8.0f, 1.0, 1.25));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 2.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BLOCK, (Object)Blocks.STONE.defaultBlockState());
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (!this.unableToMoveToOwner()) {
            --this.lightCheckInterval;
            if (this.lightCheckInterval <= 0) {
                if (this.level().getBrightness(LightLayer.BLOCK, this.blockPosition()) <= 3 && this.level().isEmptyBlock(this.blockPosition())) {
                    if (this.level().canSeeSky(this.blockPosition()) && this.level().isDay()) {
                        this.lightCheckInterval = 100;
                        return;
                    }
                    BlockState excrement = (BlockState)((Block)RisusBlocks.LIGHT_EXCREMENT.get()).defaultBlockState().setValue((Property)LightExcrementBlock.FACING, (Comparable)Direction.UP);
                    if (excrement.canSurvive((LevelReader)this.level(), this.blockPosition()) && this.level().getBlockState(this.blockPosition()).isAir()) {
                        this.level().setBlockAndUpdate(this.blockPosition(), excrement);
                        this.playSound((SoundEvent)RisusSoundEvents.LITTER_LAY_EXCREMENT.get(), 0.15f, 0.75f);
                    }
                }
                this.lightCheckInterval = 40;
            }
        } else {
            this.lightCheckInterval = 100;
        }
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        return -level.getPathfindingCostFromLightLevels(pos);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("light_block", (Tag)NbtUtils.writeBlockState((BlockState)this.getLightBlockState()));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("light_block", 10)) {
            this.setLightBlockState(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("light_block")));
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive()) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(Items.NAME_TAG)) {
                return InteractionResult.PASS;
            }
            if (player.isShiftKeyDown()) {
                if (this.getOwner() == player) {
                    if (!this.level().isClientSide()) {
                        ItemStack litterItem = new ItemStack((ItemLike)RisusItems.LITTER.get());
                        Component nameTag = this.getCustomName();
                        if (nameTag != null && !nameTag.getString().isEmpty()) {
                            litterItem.set(DataComponents.CUSTOM_NAME, (Object)nameTag);
                        }
                        litterItem.set(RisusDataComponents.BLOCK_STATE, (Object)this.getLightBlockState());
                        if (player.getInventory().add(litterItem)) {
                            this.discard();
                            this.playSound(SoundEvents.ITEM_PICKUP, 0.5f, this.getRandom().nextFloat() * 0.1f + 0.9f);
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                player.displayClientMessage((Component)Component.translatable((String)"entity.risus.player_doesnt_own").withStyle(ChatFormatting.DARK_RED), true);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void tame(Player player) {
        this.setTame(true, false);
        this.setOwnerUUID(player.getUUID());
    }

    public boolean wantsToAttack(LivingEntity owner, LivingEntity target) {
        return false;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return true;
    }

    public boolean onClimbable() {
        return false;
    }

    public void knockback(double x, double y, double z) {
    }

    protected void pushEntities() {
    }

    public boolean addEffect(MobEffectInstance instance, @Nullable Entity entity) {
        return false;
    }

    public boolean causeFallDamage(float dist, float mult, DamageSource source) {
        return false;
    }

    public void checkDespawn() {
    }

    public boolean attackable() {
        return false;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack(RisusItems.LITTER, 1, DataComponentPatch.builder().set((DataComponentType)RisusDataComponents.BLOCK_STATE.get(), (Object)this.getLightBlockState()).build());
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public void setLightBlockState(BlockState state) {
        this.getEntityData().set(BLOCK, (Object)state);
    }

    public BlockState getLightBlockState() {
        return (BlockState)this.getEntityData().get(BLOCK);
    }
}

