/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.init;

import com.bigdious.risus.Risus;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;

public class RisusTags {

    public static class BannerPatterns {
        public static final TagKey<BannerPattern> SMILE_PATTERN = BannerPatterns.create("pattern_item/smile");
        public static final TagKey<BannerPattern> DIVINITY_PATTERN = BannerPatterns.create("pattern_item/divinity");
        public static final TagKey<BannerPattern> TREE_PATTERN = BannerPatterns.create("pattern_item/tree");
        public static final TagKey<BannerPattern> ROSE_PATTERN = BannerPatterns.create("pattern_item/rose");

        private static TagKey<BannerPattern> create(String name) {
            return TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)Risus.prefix(name));
        }
    }

    public static class Enchantments {
        public static final TagKey<Enchantment> SCYTHE_ALLOWED_ENCHANTS = Enchantments.create("scythe_allowed_enchants");
        public static final TagKey<Enchantment> SOUL_SCYTHE_ALLOWED_ENCHANTS = Enchantments.create("soul_scythe_allowed_enchants");
        public static final TagKey<Enchantment> FIRE_SCYTHE_ALLOWED_ENCHANTS = Enchantments.create("fire_scythe_allowed_enchants");
        public static final TagKey<Enchantment> CINDERGLEE_SCYTHE_ALLOWED_ENCHANTS = Enchantments.create("cinderglee_scythe_allowed_enchants");
        public static final TagKey<Enchantment> CRESCENT_DISASTER_ALLOWED_ENCHANTS = Enchantments.create("crescent_disaster_allowed_enchants");
        public static final TagKey<Enchantment> THOUSAND_BLADE_ALLOWED_ENCHANTS = Enchantments.create("thousand_blade_allowed_enchants");
        public static final TagKey<Enchantment> TOOTHKNOCKER_ALLOWED_ENCHANTS = Enchantments.create("toothknocker_allowed_enchants");
        public static final TagKey<Enchantment> BOOMSTICK_ALLOWED_ENCHANTS = Enchantments.create("boomstick_allowed_enchants");

        private static TagKey<Enchantment> create(String name) {
            return TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }

    public static class Entities {
        public static final TagKey<EntityType<?>> OFFSPRING = Entities.create("offspring");
        public static final TagKey<EntityType<?>> BELOVED = Entities.create("beloved");
        public static final TagKey<EntityType<?>> CANT_BE_STOLEN_FROM = Entities.create("cant_be_stolen_from");
        public static final TagKey<EntityType<?>> BREAKS_DEPTH_VASES = Entities.create("breaks_depth_vases");
        public static final TagKey<EntityType<?>> YOUTH_BANNED = Entities.create("youth_banned");
        public static final TagKey<EntityType<?>> YOUTH_SHRINKS = Entities.create("youth_shrinks");

        private static TagKey<EntityType<?>> create(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }

    public static class Items {
        public static final TagKey<Item> BONDKNOT_LOGS = ItemTags.create((ResourceLocation)Risus.prefix("bondknot_logs"));
        public static final TagKey<Item> JOYFLAME_FIRE_BASE_BLOCKS = ItemTags.create((ResourceLocation)Risus.prefix("joyflame_fire_base_blocks"));
        public static final TagKey<Item> FROGLIGHT_BLOCKS = ItemTags.create((ResourceLocation)Risus.prefix("froglight_blocks"));
        public static final TagKey<Item> BONE_BLOCK_VARIATION = Items.create("bone_block_variation");
        public static final TagKey<Item> FOSSIL_VARIATION = Items.create("fossil_variation");
        public static final TagKey<Item> WILLFUL_WEAPON = Items.create("willful_weapon");
        public static final TagKey<Item> EYE = Items.create("eye");
        public static final TagKey<Item> BASE_TISSUE = Items.create("base_tissue");
        public static final TagKey<Item> HURTS_ANGEL_WINGS = Items.create("hurts_angel_wings");
        public static final TagKey<Item> LIGHTLY_HURTS_ANGEL_WINGS = Items.create("lightly_hurts_angel_wings");
        public static final TagKey<Item> STOPS_THREAD_WINGS_RENDERING = Items.create("stops_thread_wings_rendering");
        public static final TagKey<Item> ALTERABLE_GATES = Items.create("alterable_gates");
        public static final TagKey<Item> ALTERABLE_FENCES = Items.create("alterable_fences");
        public static final TagKey<Item> ALTERABLE_TRAPDOORS = Items.create("alterable_trapdoors");
        public static final TagKey<Item> ALTERABLE_HANGING_SIGNS = Items.create("alterable_hanging_signs");
        public static final TagKey<Item> ALTERABLE_SIGNS = Items.create("alterable_signs");
        public static final TagKey<Item> ALTERABLE_DOORS = Items.create("alterable_doors");
        public static final TagKey<Item> ALTERABLE_BUTTONS = Items.create("alterable_buttons");
        public static final TagKey<Item> ALTERABLE_PRESSURE_PLATES = Items.create("alterable_pressure_plates");
        public static final TagKey<Item> ALTERABLE_SLABS = Items.create("alterable_slabs");
        public static final TagKey<Item> ALTERABLE_STAIRS = Items.create("alterable_stairs");
        public static final TagKey<Item> ALTERABLE_PLANKS = Items.create("alterable_planks");
        public static final TagKey<Item> ALTERABLE_LOGS = Items.create("alterable_logs");
        public static final TagKey<Item> CURIOS_HANDS = Items.createCurios("hands");
        public static final TagKey<Item> CURIOS_BELT = Items.createCurios("belt");
        public static final TagKey<Item> CURIOS_CHARM = Items.createCurios("charm");
        public static final TagKey<Item> CURIOS_HEAD = Items.createCurios("head");

        private static TagKey<Item> create(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }

        private static TagKey<Item> createCurios(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> HAS_ALTERATION_SITE = Biomes.create("has_structure/alteration_site");
        public static final TagKey<Biome> HAS_GRASSY_MAW = Biomes.create("has_structure/grassy_maw");
        public static final TagKey<Biome> HAS_SANDY_MAW = Biomes.create("has_structure/sandy_maw");
        public static final TagKey<Biome> HAS_ENDY_MAW = Biomes.create("has_structure/endy_maw");
        public static final TagKey<Biome> HAS_FAMILY_TREE = Biomes.create("has_structure/family_tree");
        public static final TagKey<Biome> HAS_ANGEL_ALTAR = Biomes.create("has_structure/angel_altar");
        public static final TagKey<Biome> HAS_GREAT_BODY = Biomes.create("has_structure/great_body");
        public static final TagKey<Biome> HAS_FLOWER_FIELD = Biomes.create("has_structure/flower_field");
        public static final TagKey<Biome> HAS_DUNGEON = Biomes.create("has_structure/dungeon");
        public static final TagKey<Biome> HAS_BLOOD_WELL = Biomes.create("has_structure/blood_well");
        public static final TagKey<Biome> HAS_LAB = Biomes.create("has_structure/lab");
        public static final TagKey<Biome> HAS_DRAXOLOTL_REMAINS = Biomes.create("has_structure/draxolotl_remains");

        private static TagKey<Biome> create(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> BONDKNOT_LOGS = BlockTags.create((ResourceLocation)Risus.prefix("bondknot_logs"));
        public static final TagKey<Block> JOYFLAME_FIRE_BASE_BLOCKS = BlockTags.create((ResourceLocation)Risus.prefix("joyflame_fire_base_blocks"));
        public static final TagKey<Block> COPPER_AMALGAM_VARIATION = Blocks.create("copper_amalgam_variation");
        public static final TagKey<Block> WAXED_COPPER_AMALGAM_VARIATION = Blocks.create("waxed_copper_amalgam_variation");
        public static final TagKey<Block> LITTER_ALLOWED_LIGHT_BLOCKS = Blocks.create("litter_allowed_light_blocks");
        public static final TagKey<Block> ILLEGAL_LITTER_ALLOWED_LIGHT_BLOCKS = Blocks.create("non_canon_litter_allowed_light_blocks");
        public static final TagKey<Block> SPAWN_SPIRE_ON = Blocks.create("spawn_spire_on");

        private static TagKey<Block> create(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"risus", (String)name));
        }
    }
}

