/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.inventory;

import com.bigdious.risus.init.RisusMenuType;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MawGutsMenu
extends AbstractContainerMenu {
    private final Container mawGuts;

    public MawGutsMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(54));
    }

    public MawGutsMenu(int id, Inventory inventory, Container container) {
        super((MenuType)RisusMenuType.MAW_GUTS.get(), id);
        this.mawGuts = container;
        MawGutsMenu.checkContainerSize((Container)this.mawGuts, (int)54);
        container.startOpen(inventory.player);
        for (int gutsY = 0; gutsY < 6; ++gutsY) {
            for (int gutsX = 0; gutsX < 9; ++gutsX) {
                this.addSlot(new Slot(container, gutsX + gutsY * 9, 8 + gutsX * 18, 18 + gutsY * 18));
            }
        }
        for (int invY = 0; invY < 3; ++invY) {
            for (int invX = 0; invX < 9; ++invX) {
                this.addSlot(new Slot((Container)inventory, invX + invY * 9 + 9, 8 + invX * 18, 103 + invY * 18 + 36));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.addSlot(new Slot((Container)inventory, hotbar, 8 + hotbar * 18, 197));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotNum) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNum);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNum < 54 ? !this.moveItemStackTo(itemstack1, 54, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return this.mawGuts.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.mawGuts.stopOpen(player);
    }
}

