/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items;

import com.bigdious.risus.attachment.ExBurnAttachment;
import com.bigdious.risus.blocks.interfaces.OrganicMatterableBlock;
import com.bigdious.risus.event.OrganicMatterEvent;
import com.bigdious.risus.event.RisusEvents;
import com.bigdious.risus.init.RisusBlocks;
import com.bigdious.risus.init.RisusDataAttachments;
import com.bigdious.risus.init.RisusParticles;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.util.ServerParticleUtils;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class OrganicMatterItem
extends Item {
    public static final Supplier<BiMap<Block, Block>> PRESERVABLE = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)RisusBlocks.TISSUE.get()), (Object)((Block)RisusBlocks.LIVING_TISSUE.get())).put((Object)((Block)RisusBlocks.ROTTING_TISSUE.get()), (Object)((Block)RisusBlocks.ROTTED_TISSUE.get())).put((Object)((Block)RisusBlocks.DECOMPOSING_TISSUE.get()), (Object)((Block)RisusBlocks.DECOMPOSED_TISSUE.get())).put((Object)((Block)RisusBlocks.DECAYING_TISSUE.get()), (Object)((Block)RisusBlocks.DECAYED_TISSUE.get())).build());

    public OrganicMatterItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ((ExBurnAttachment)entity.getData(RisusDataAttachments.EX_BURN)).incrementHealth(entity);
        return super.finishUsingItem(stack, level, entity);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (OrganicMatterItem.applyOrganicMatter(context.getItemInHand(), level, blockpos, context.getPlayer())) {
            if (!level.isClientSide) {
                context.getPlayer().gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                level.levelEvent(1505, blockpos, 15);
            }
            OrganicMatterItem.addGrowthParticles((LevelAccessor)level, blockpos, 10);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return OrganicMatterItem.getWaxed(blockstate).map(state -> {
            Player player = context.getPlayer();
            ItemStack itemstack = context.getItemInHand();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
            itemstack.consume(1, (LivingEntity)player);
            level.setBlock(blockpos, state, 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)state));
            ServerParticleUtils.spawnParticlesOnBlockFaces(level, blockpos, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)RisusBlocks.TISSUE.get())), (IntProvider)UniformInt.of((int)6, (int)12));
            level.playSound(null, blockpos, (SoundEvent)RisusSoundEvents.ORGANIC_MATTER_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }).orElse(InteractionResult.PASS);
    }

    public static boolean applyOrganicMatter(ItemStack stack, Level level, BlockPos pos, @Nullable Player player) {
        OrganicMatterableBlock organicMatterableBlock;
        BlockState blockstate = level.getBlockState(pos);
        OrganicMatterEvent event = RisusEvents.fireOrganicMatterEvent(player, level, pos, blockstate, stack);
        if (event.isCanceled()) {
            return event.isSuccessful();
        }
        Block block = blockstate.getBlock();
        if (block instanceof OrganicMatterableBlock && (organicMatterableBlock = (OrganicMatterableBlock)block).isValidOrganicMatterTarget((LevelReader)level, pos, blockstate)) {
            if (level instanceof ServerLevel) {
                if (organicMatterableBlock.isOrganicMatterSuccess(level, level.getRandom(), pos, blockstate)) {
                    organicMatterableBlock.performOrganicMatter((ServerLevel)level, level.getRandom(), pos, blockstate);
                }
                stack.consume(1, (LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    public static void addGrowthParticles(LevelAccessor pLevel, BlockPos pPos, int pData) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        Block block = blockstate.getBlock();
        if (block instanceof OrganicMatterableBlock) {
            OrganicMatterableBlock organicMatterableBlock = (OrganicMatterableBlock)block;
            BlockPos blockpos = organicMatterableBlock.getOMBParticlePos(pPos);
            switch (organicMatterableBlock.getOMBType()) {
                case NEIGHBOR_SPREADER: {
                    ServerParticleUtils.spawnParticles(pLevel, blockpos, pData * 3, 3.0, 1.0, false, (ParticleOptions)RisusParticles.BLOCK_ORGANIC_PARTICLE.get());
                    break;
                }
                case GROWER: {
                    ServerParticleUtils.spawnParticleInBlock(pLevel, blockpos, pData, (ParticleOptions)RisusParticles.BLOCK_ORGANIC_PARTICLE.get());
                }
            }
        } else if (blockstate.is(Blocks.WATER)) {
            ServerParticleUtils.spawnParticles(pLevel, pPos, pData * 3, 3.0, 1.0, false, (ParticleOptions)RisusParticles.BLOCK_ORGANIC_PARTICLE.get());
        }
    }

    public static Optional<BlockState> getWaxed(BlockState state) {
        return Optional.ofNullable((Block)PRESERVABLE.get().get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
    }
}

