/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items.armor;

import com.bigdious.risus.init.RisusItems;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class RisusArmorItem
extends ArmorItem {
    public RisusArmorItem(Holder<ArmorMaterial> armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.is((Item)RisusItems.SKIN_BOOTS.get()) || stack.is((Item)RisusItems.THREADERS_OF_THE_FIRMAMENT.get());
    }

    public static ItemAttributeModifiers createSkinAttributes(ArmorItem.Type type, int armor) {
        ResourceLocation armorLocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        return ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(armorLocation, (double)armor, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.MAX_HEALTH, new AttributeModifier(armorLocation, 5.0, AttributeModifier.Operation.ADD_VALUE), group).build();
    }

    public static ItemAttributeModifiers createBloodFeatherAttributes(ArmorItem.Type type, int armor) {
        ResourceLocation armorLocation = ResourceLocation.withDefaultNamespace((String)("armor." + type.getName()));
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)type.getSlot());
        return ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(armorLocation, (double)armor, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.STEP_HEIGHT, new AttributeModifier(armorLocation, 0.4, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.GRAVITY, new AttributeModifier(armorLocation, -0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), group).add(Attributes.SNEAKING_SPEED, new AttributeModifier(armorLocation, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), group).add(Attributes.MOVEMENT_SPEED, new AttributeModifier(armorLocation, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), group).add(Attributes.JUMP_STRENGTH, new AttributeModifier(armorLocation, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), group).add(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(armorLocation, 10.0, AttributeModifier.Operation.ADD_VALUE), group).add(Attributes.FALL_DAMAGE_MULTIPLIER, new AttributeModifier(armorLocation, -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), group).build();
    }
}

