/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items.summoners;

import com.bigdious.risus.entity.Litter;
import com.bigdious.risus.init.RisusDataComponents;
import com.bigdious.risus.init.RisusEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LitterItem
extends Item {
    public LitterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult result = LitterItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack stack = player.getItemInHand(hand);
        if (result.getType() == HitResult.Type.BLOCK) {
            Litter entity;
            Vec3 vec = result.getLocation();
            if (!level.isClientSide() && (entity = (Litter)((EntityType)RisusEntities.LITTER.get()).create(level)) != null) {
                entity.moveTo(vec);
                entity.tame(player);
                entity.setLightBlockState((BlockState)stack.getOrDefault(RisusDataComponents.BLOCK_STATE, (Object)Blocks.STONE.defaultBlockState()));
                level.addFreshEntity((Entity)entity);
                if (stack.has(DataComponents.CUSTOM_NAME)) {
                    entity.setCustomName(stack.getHoverName());
                }
                stack.consume(1, (LivingEntity)player);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (stack.has(RisusDataComponents.BLOCK_STATE)) {
            tooltip.add((Component)((BlockState)stack.get(RisusDataComponents.BLOCK_STATE)).getBlock().getName().withStyle(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}

