/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items.weapons;

import com.bigdious.risus.Risus;
import com.bigdious.risus.entity.projectile.BloodSlash;
import com.bigdious.risus.init.RisusDamageTypes;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ThousandBladeItem
extends SwordItem {
    public ThousandBladeItem(Tier material, Item.Properties properties) {
        super(material, properties);
    }

    public static ItemAttributeModifiers createThousandBladeAttributes(Tier tier, int damage, float speed) {
        return SwordItem.createAttributes((Tier)tier, (int)damage, (float)speed).withModifierAdded(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(Risus.prefix("knockback_res_modifier"), 0.1, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Risus.prefix("range_modifier"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(Risus.prefix("speed_modifier"), (double)-0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), EquipmentSlotGroup.MAINHAND);
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(RisusTags.Enchantments.THOUSAND_BLADE_ALLOWED_ENCHANTS);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(RisusTags.Enchantments.THOUSAND_BLADE_ALLOWED_ENCHANTS);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int useTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.getUseDuration(stack, entity) - useTicks;
            if (i >= 20) {
                if (!level.isClientSide()) {
                    int multishot = stack.getEnchantmentLevel(level.registryAccess().holderOrThrow(Enchantments.MULTISHOT));
                    this.shoot((ServerLevel)level, (LivingEntity)player, player.getUsedItemHand(), stack, multishot);
                    if (!player.isCreative()) {
                        player.hurt(entity.damageSources().source(RisusDamageTypes.VAMPIRISM), (float)(1 + 2 * multishot));
                    }
                }
                level.playSound(null, (Entity)entity, (SoundEvent)RisusSoundEvents.THOUSAND_BLADE_SLASH.get(), SoundSource.NEUTRAL, 1.0f, 0.6f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected void shoot(ServerLevel level, LivingEntity living, InteractionHand hand, ItemStack stack, int multishot) {
        float arrowSize = 1 + multishot * 2;
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)stack, (Entity)living, (float)0.0f);
        float f1 = arrowSize == 1.0f ? 0.0f : 2.0f * f / arrowSize - 1.0f;
        float f2 = (arrowSize - 1.0f) % 2.0f * f1 / 2.0f;
        float f3 = 1.0f;
        int i = 0;
        while ((float)i < arrowSize) {
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            BloodSlash slash = new BloodSlash((Level)level, living, stack);
            this.shootProjectile(living, slash, 1.3f, 1.0f, f4);
            level.addFreshEntity((Entity)slash);
            stack.hurtAndBreak(1, living, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (stack.isEmpty()) break;
            ++i;
        }
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, float velocity, float inaccuracy, float angle) {
        Vec3 vec3 = shooter.getUpVector(1.0f);
        Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
        Vec3 vec31 = shooter.getViewVector(1.0f);
        Vector3f vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public static class ItemExtensions
    implements IClientItemExtensions {
        public static final ItemExtensions INSTANCE = new ItemExtensions();

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            return HumanoidModel.ArmPose.valueOf((String)"RISUS_THOUSAND_BLADE");
        }
    }
}

