/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.items.weapons;

import com.bigdious.risus.Risus;
import com.bigdious.risus.init.RisusItems;
import com.bigdious.risus.init.RisusMobEffects;
import com.bigdious.risus.init.RisusSoundEvents;
import com.bigdious.risus.init.RisusTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbility;

public class ToothknockerItem
extends SwordItem {
    public ToothknockerItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public static ItemAttributeModifiers createKnuckleAttributes(Tier tier, int damage, float speed) {
        return SwordItem.createAttributes((Tier)tier, (int)damage, (float)speed).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Risus.prefix("range_modifier"), -0.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(Risus.prefix("fall_distance_modifier"), 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
    }

    public boolean mineBlock(ItemStack itemstack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            itemstack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(RisusTags.Enchantments.TOOTHKNOCKER_ALLOWED_ENCHANTS);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(RisusTags.Enchantments.TOOTHKNOCKER_ALLOWED_ENCHANTS);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.getItemInHand(InteractionHand.MAIN_HAND).is((Item)RisusItems.TOOTHKNOCKER.get()) && player.getItemInHand(InteractionHand.OFF_HAND).is((Item)RisusItems.TOOTHKNOCKER.get())) {
            player.addEffect(new MobEffectInstance(RisusMobEffects.TOOTHLUSTER, 0, 0, false, false, false));
            player.getOffhandItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            Level level = player.level();
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)RisusSoundEvents.TOOTHKNOCKER_CRACK.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player player, InteractionHand pHand) {
        ItemStack itemstack = player.getItemInHand(pHand);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1 || player.isFallFlying() || player.isInWater()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        float f7 = player.getYRot();
        float f = player.getXRot();
        float f1 = -Mth.sin((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f2 = -Mth.sin((float)(f * ((float)Math.PI / 180)));
        float f3 = Mth.cos((float)(f7 * ((float)Math.PI / 180))) * Mth.cos((float)(f * ((float)Math.PI / 180)));
        float f4 = Mth.sqrt((float)(f1 * f1 + f2 * f2 + f3 * f3));
        float f5 = 0.75f;
        player.push((double)(f1 *= f5 / f4), (double)(f2 *= f5 / f4), (double)(f3 *= f5 / f4));
        player.move(MoverType.PISTON, new Vec3(0.0, 1.1999999284744263, 0.0));
        for (int i = 0; i < 10; ++i) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.POOF, player.getRandomX(0.5), player.getRandomY(), player.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
        itemstack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        player.getCooldowns().addCooldown((Item)this, 30);
        pLevel.playSound(player, player.getOnPos().above(), (SoundEvent)RisusSoundEvents.TOOTHKNOCKER_DASH.get(), SoundSource.PLAYERS);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return false;
    }
}

