/*
 * Decompiled with CFR 0.152.
 */
package com.bigdious.risus.util;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ServerParticleUtils {
    public static void spawnParticlesOnBlockFaces(Level level, BlockPos pos, ParticleOptions particle, IntProvider count) {
        for (Direction direction : Direction.values()) {
            ServerParticleUtils.spawnParticlesOnBlockFace(level, pos, particle, count, direction, () -> ServerParticleUtils.getRandomSpeedRanges(level.random), 0.55);
        }
    }

    public static void spawnParticlesOnBlockFace(Level level, BlockPos pos, ParticleOptions particle, IntProvider count, Direction direction, Supplier<Vec3> speedSupplier, double spread) {
        int i = count.sample(level.random);
        for (int j = 0; j < i; ++j) {
            ServerParticleUtils.spawnParticleOnFace(level, pos, direction, particle, speedSupplier.get(), spread);
        }
    }

    private static Vec3 getRandomSpeedRanges(RandomSource random) {
        return new Vec3(Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5));
    }

    public static void spawnParticlesAlongAxis(Direction.Axis axis, Level level, BlockPos pos, double spread, ParticleOptions particle, UniformInt count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
            boolean flag = axis == Direction.Axis.X;
            boolean flag1 = axis == Direction.Axis.Y;
            boolean flag2 = axis == Direction.Axis.Z;
            int i = count.sample(level.random);
            for (int j = 0; j < i; ++j) {
                double d0 = vec3.x + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * (flag ? 0.5 : spread);
                double d1 = vec3.y + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * (flag1 ? 0.5 : spread);
                double d2 = vec3.z + Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) * (flag2 ? 0.5 : spread);
                double d3 = flag ? Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) : 0.0;
                double d4 = flag1 ? Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) : 0.0;
                double d5 = flag2 ? Mth.nextDouble((RandomSource)level.random, (double)-1.0, (double)1.0) : 0.0;
                serverLevel.sendParticles(particle, d0, d1, d2, 1, 0.0, 0.0, 0.0, (d3 + d4 + d5) / 3.0);
            }
        }
    }

    public static void spawnParticleOnFace(Level level, BlockPos pos, Direction direction, ParticleOptions particle, Vec3 speed, double spread) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
            int i = direction.getStepX();
            int j = direction.getStepY();
            int k = direction.getStepZ();
            double d0 = vec3.x + (i == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)i * spread);
            double d1 = vec3.y + (j == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)j * spread);
            double d2 = vec3.z + (k == 0 ? Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5) : (double)k * spread);
            double d3 = i == 0 ? speed.x() : 0.0;
            double d4 = j == 0 ? speed.y() : 0.0;
            double d5 = k == 0 ? speed.z() : 0.0;
            serverLevel.sendParticles(particle, d0, d1, d2, 1, 0.0, 0.0, 0.0, (d3 + d4 + d5) / 3.0);
        }
    }

    public static void spawnParticleBelow(Level level, BlockPos pos, RandomSource random, ParticleOptions particle) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double d0 = (double)pos.getX() + random.nextDouble();
            double d1 = (double)pos.getY() - 0.05;
            double d2 = (double)pos.getZ() + random.nextDouble();
            serverLevel.sendParticles(particle, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticleInBlock(LevelAccessor level, BlockPos pos, int count, ParticleOptions particle) {
        double d0 = 0.5;
        BlockState blockstate = level.getBlockState(pos);
        double d1 = blockstate.isAir() ? 1.0 : blockstate.getShape((BlockGetter)level, pos).max(Direction.Axis.Y);
        ServerParticleUtils.spawnParticles(level, pos, count, 0.5, d1, true, particle);
    }

    public static void spawnParticles(LevelAccessor level, BlockPos pos, int count, double xzSpread, double ySpread, boolean allowInAir, ParticleOptions particle) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource randomsource = level.getRandom();
            for (int i = 0; i < count; ++i) {
                double d0 = randomsource.nextGaussian() * 0.02;
                double d1 = randomsource.nextGaussian() * 0.02;
                double d2 = randomsource.nextGaussian() * 0.02;
                double d3 = 0.5 - xzSpread;
                double d4 = (double)pos.getX() + d3 + randomsource.nextDouble() * xzSpread * 2.0;
                double d5 = (double)pos.getY() + randomsource.nextDouble() * ySpread;
                double d6 = (double)pos.getZ() + d3 + randomsource.nextDouble() * xzSpread * 2.0;
                if (!allowInAir && level.getBlockState(BlockPos.containing((double)d4, (double)d5, (double)d6).below()).isAir()) continue;
                serverLevel.sendParticles(particle, d4, d5, d6, 1, 0.0, 0.0, 0.0, d0);
            }
        }
    }

    public static void spawnSmashAttackParticles(LevelAccessor level, BlockPos pos, int power) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = pos.getCenter().add(0.0, 0.5, 0.0);
            BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.DUST_PILLAR, level.getBlockState(pos));
            int i = 0;
            while ((float)i < (float)power / 3.0f) {
                double d0 = vec3.x + level.getRandom().nextGaussian() / 2.0;
                double d1 = vec3.y;
                double d2 = vec3.z + level.getRandom().nextGaussian() / 2.0;
                double d3 = level.getRandom().nextGaussian() * (double)0.2f;
                double d4 = level.getRandom().nextGaussian() * (double)0.2f;
                double d5 = level.getRandom().nextGaussian() * (double)0.2f;
                serverLevel.sendParticles((ParticleOptions)blockparticleoption, d0, d1, d2, 1, 0.0, 0.0, 0.0, (d3 + d4 + d5) / 3.0);
                ++i;
            }
            int j = 0;
            while ((float)j < (float)power / 1.5f) {
                double d6 = vec3.x + 3.5 * Math.cos(j) + level.getRandom().nextGaussian() / 2.0;
                double d7 = vec3.y;
                double d8 = vec3.z + 3.5 * Math.sin(j) + level.getRandom().nextGaussian() / 2.0;
                double d9 = level.getRandom().nextGaussian() * (double)0.05f;
                double d10 = level.getRandom().nextGaussian() * (double)0.05f;
                double d11 = level.getRandom().nextGaussian() * (double)0.05f;
                serverLevel.sendParticles((ParticleOptions)blockparticleoption, d6, d7, d8, 1, 0.0, 0.0, 0.0, (d9 + d10 + d11) / 3.0);
                ++j;
            }
        }
    }
}

