/*
 * Decompiled with CFR 0.152.
 */
package io.github.suel_ki.foodeffecttooltips;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.suel_ki.foodeffecttooltips.config.FoodEffectsConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import org.jetbrains.annotations.NotNull;

public class TooltipHelper {
    public static boolean shouldShowTooltip(ItemStack stack) {
        Item item = stack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        String itemId = id.toString();
        String modId = id.getNamespace();
        if (((List)FoodEffectsConfig.WhitelistedItemIdentifiers.get()).contains(itemId)) {
            return true;
        }
        if (((List)FoodEffectsConfig.WhitelistedModsIDs.get()).contains(modId)) {
            return true;
        }
        if (((List)FoodEffectsConfig.BlacklistedItemIdentifiers.get()).contains(itemId)) {
            return false;
        }
        if (((List)FoodEffectsConfig.BlacklistedModsIDs.get()).contains(modId)) {
            return false;
        }
        return FoodEffectsConfig.DefaultTooltipBehavior.get() == FoodEffectsConfig.TooltipBehavior.SHOW;
    }

    public static void addFoodComponentEffectTooltip(@NotNull ItemStack stack, @NotNull Consumable foodProperties, @NotNull List<Component> tooltip, float tickRate) {
        if (foodProperties.onConsumeEffects().isEmpty()) {
            return;
        }
        boolean isDrink = stack.getUseAnimation() == ItemUseAnimation.DRINK;
        TooltipHelper.buildFoodEffectTooltip(tooltip, foodProperties.onConsumeEffects(), tickRate, isDrink);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void buildFoodEffectTooltip(@NotNull List<Component> tooltip, List<ConsumeEffect> effects, float tickRate, boolean drink) {
        if (effects.isEmpty()) {
            return;
        }
        ArrayList modifiers = Lists.newArrayList();
        for (ConsumeEffect entry : effects) {
            float probability;
            if (!(entry instanceof ApplyStatusEffectsConsumeEffect)) continue;
            Object applyStatusEffectsConsumeEffect = (ApplyStatusEffectsConsumeEffect)entry;
            try {
                float f;
                List list;
                List effects1 = list = applyStatusEffectsConsumeEffect.effects();
                probability = f = applyStatusEffectsConsumeEffect.probability();
                applyStatusEffectsConsumeEffect = effects1.iterator();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            while (applyStatusEffectsConsumeEffect.hasNext()) {
                MobEffectInstance mobEffectInstance = (MobEffectInstance)applyStatusEffectsConsumeEffect.next();
                MutableComponent mutablecomponent = Component.translatable((String)mobEffectInstance.getDescriptionId());
                Holder holder = mobEffectInstance.getEffect();
                ((MobEffect)holder.value()).createModifiers(mobEffectInstance.getAmplifier(), (attribute, modifier) -> modifiers.add(new Pair(attribute, modifier)));
                if (mobEffectInstance.getAmplifier() > 0) {
                    mutablecomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.translatable((String)("potion.potency." + mobEffectInstance.getAmplifier()))});
                }
                if (!mobEffectInstance.endsWithin(20)) {
                    mutablecomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.formatDuration((MobEffectInstance)mobEffectInstance, (float)1.0f, (float)tickRate)});
                }
                if (probability < 1.0f) {
                    mutablecomponent = Component.translatable((String)"foodeffecttooltips.food.withChance", (Object[])new Object[]{mutablecomponent, Math.round(probability * 100.0f)});
                }
                tooltip.add((Component)mutablecomponent.withStyle(((MobEffect)holder.value()).getCategory().getTooltipFormatting()));
            }
        }
        if (!modifiers.isEmpty()) {
            tooltip.add(CommonComponents.EMPTY);
            if (drink) {
                tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            } else {
                tooltip.add((Component)Component.translatable((String)"foodeffecttooltips.food.whenEaten").withStyle(ChatFormatting.DARK_PURPLE));
            }
            for (Pair modifier2 : modifiers) {
                AttributeModifier attributeModifier = (AttributeModifier)modifier2.getSecond();
                double d = attributeModifier.amount();
                double e = attributeModifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributeModifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? attributeModifier.amount() : attributeModifier.amount() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + attributeModifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.translatable((String)((Attribute)((Holder)modifier2.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + attributeModifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e *= -1.0), Component.translatable((String)((Attribute)((Holder)modifier2.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }
}

