/*
 * Decompiled with CFR 0.152.
 */
package io.github.suel_ki.foodeffecttooltips.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class FoodEffectsConfig {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final ModConfigSpec.BooleanValue ShowSuspiciousStewTooltips;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> WhitelistedItemIdentifiers;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> WhitelistedModsIDs;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> BlacklistedItemIdentifiers;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> BlacklistedModsIDs;
    public static final ModConfigSpec.EnumValue<TooltipBehavior> DefaultTooltipBehavior;

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("food effects tooltip");
        ShowSuspiciousStewTooltips = builder.comment("Show suspicious stew food effects tooltips").define("showSuspiciousStewTooltips", false);
        WhitelistedItemIdentifiers = builder.comment("Whitelisted Item.").defineList("whitelistItems", List.of("modid:testitem"), itemName -> itemName instanceof String);
        WhitelistedModsIDs = builder.comment("Whitelisted Item.").defineList("whitelistModsIDs", List.of("modid"), modName -> modName instanceof String);
        BlacklistedItemIdentifiers = builder.comment("Blacklisted Item.").defineList("blacklistItems", List.of("modid:testitem"), itemName -> itemName instanceof String);
        BlacklistedModsIDs = builder.comment("Blacklisted Mod IDs.").defineList("blacklistModsIDs", List.of("modid", "farmersdelight", "expandeddelight", "moredelight", "oceansdelight", "ubesdelight", "vinery"), modName -> modName instanceof String);
        DefaultTooltipBehavior = builder.comment("Default tooltip behavior for unlisted items").defineEnum("defaultTooltipBehavior", (Enum)TooltipBehavior.SHOW);
        builder.pop();
        CLIENT_SPEC = builder.build();
    }

    public static enum TooltipBehavior {
        SHOW,
        HIDE;

    }
}

