/*
 * Decompiled with CFR 0.152.
 */
package lol.hub.fastharvest;

import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class Plugin
extends JavaPlugin
implements Listener {
    private static final Set<Material> crops = Set.of(Material.WHEAT, Material.CARROTS, Material.POTATOES, Material.BEETROOTS, Material.NETHER_WART);
    private static final Set<Material> seeds = Set.of(Material.WHEAT_SEEDS, Material.BEETROOT_SEEDS);

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)this);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteractEvent(PlayerInteractEvent ev) {
        ItemMeta stack2;
        if (ev.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (ev.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = ev.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!crops.contains(block.getType())) {
            return;
        }
        Ageable data = (Ageable)block.getBlockData();
        if (data.getAge() < data.getMaximumAge()) {
            return;
        }
        ItemStack tool = ItemStack.empty();
        if (this.isHoe(ev.getItem())) {
            tool = ev.getItem();
        }
        for (ItemMeta stack2 : block.getDrops(tool)) {
            if (seeds.contains(stack2.getType())) {
                if (!ThreadLocalRandom.current().nextBoolean()) continue;
                stack2.setAmount(1);
            } else if (!this.isHoe(ev.getItem()) && stack2.getAmount() > 1) {
                stack2.setAmount(stack2.getAmount() - 1);
            }
            block.getWorld().dropItemNaturally(block.getLocation().add(0.0, 0.5, 0.0), (ItemStack)stack2);
        }
        stack2 = tool.getItemMeta();
        if (stack2 instanceof Damageable) {
            Damageable damageable = (Damageable)stack2;
            int damageChance = 100 / (tool.getEnchantmentLevel(Enchantment.UNBREAKING) + 1);
            if (ThreadLocalRandom.current().nextInt(1, 101) <= damageChance) {
                damageable.setDamage(damageable.getDamage() + 1);
                tool.setItemMeta((ItemMeta)damageable);
            }
        }
        data.setAge(0);
        block.setBlockData((BlockData)data);
        block.getWorld().playSound(block.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 0.33f, 0.8f);
    }

    private boolean isHoe(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return switch (stack.getType()) {
            case Material.WOODEN_HOE, Material.STONE_HOE, Material.GOLDEN_HOE, Material.IRON_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE, Material.LEGACY_WOOD_HOE, Material.LEGACY_STONE_HOE, Material.LEGACY_GOLD_HOE, Material.LEGACY_IRON_HOE, Material.LEGACY_DIAMOND_HOE -> true;
            default -> false;
        };
    }
}

