/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.client.handler;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armoredfoes.ArmoredFoes;
import fuzs.armoredfoes.client.model.geom.ModModelLayers;
import fuzs.armoredfoes.client.renderer.entity.layers.IllagerArmorLayer;
import fuzs.armoredfoes.client.renderer.entity.layers.VillagerArmorLayer;
import fuzs.armoredfoes.client.renderer.entity.layers.WitchArmorLayer;
import fuzs.armoredfoes.init.ModRegistry;
import fuzs.puzzleslib.api.client.renderer.v1.RenderStateExtraData;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.WitchModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.entity.state.WitchRenderState;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ItemStack;

public class EquipmentRenderingHandler {
    public static final ContextKey<Map<EquipmentSlot, ItemStack>> ARMOR_EQUIPMENT_KEY = new ContextKey(ArmoredFoes.id("armor_equipment"));

    public static void onExtractRenderState(Entity entity, EntityRenderState renderState, float partialTick) {
        if (!(renderState instanceof HumanoidRenderState) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.getType().is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
                    builder.put((Object)equipmentSlot, (Object)HumanoidMobRenderer.getEquipmentIfRenderable((LivingEntity)livingEntity, (EquipmentSlot)equipmentSlot));
                }
                RenderStateExtraData.set((EntityRenderState)renderState, ARMOR_EQUIPMENT_KEY, (Object)builder.build());
            }
        }
    }

    public static void addLivingEntityRenderLayers(final EntityType<?> entityType, LivingEntityRenderer<?, ?, ?> entityRenderer, EntityRendererProvider.Context context) {
        if (entityRenderer.getModel() instanceof IllagerModel) {
            entityRenderer.addLayer((RenderLayer)new IllagerArmorLayer<IllagerRenderState>(entityRenderer, ModModelLayers.bake(ModModelLayers.ILLAGER_CROSSED_ARMOR, context.getModelSet(), IllagerModel::new), ModModelLayers.bake(ModModelLayers.ILLAGER_BABY_CROSSED_ARMOR, context.getModelSet(), IllagerModel::new), context.getEquipmentRenderer()){

                @Override
                public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, IllagerRenderState renderState, float yRot, float xRot) {
                    if (entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG) && renderState.armPose == AbstractIllager.IllagerArmPose.CROSSED) {
                        super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
                    }
                }
            });
            entityRenderer.addLayer((RenderLayer)new IllagerArmorLayer<IllagerRenderState>(entityRenderer, ModModelLayers.bake(ModModelLayers.ILLAGER_ARMOR, context.getModelSet(), IllagerModel::new), ModModelLayers.bake(ModModelLayers.ILLAGER_BABY_ARMOR, context.getModelSet(), IllagerModel::new), context.getEquipmentRenderer()){

                @Override
                public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, IllagerRenderState renderState, float yRot, float xRot) {
                    if (entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG) && renderState.armPose != AbstractIllager.IllagerArmPose.CROSSED) {
                        super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        } else if (entityRenderer.getModel() instanceof WitchModel) {
            entityRenderer.addLayer((RenderLayer)new WitchArmorLayer((RenderLayerParent)entityRenderer, (ArmorModelSet)ModModelLayers.bake(ModModelLayers.WITCH_ARMOR, context.getModelSet(), WitchModel::new), (ArmorModelSet)ModModelLayers.bake(ModModelLayers.WITCH_BABY_ARMOR, context.getModelSet(), WitchModel::new), context.getEquipmentRenderer(), (EntityType)entityType){
                final /* synthetic */ EntityType val$entityType;
                {
                    this.val$entityType = entityType;
                    super((RenderLayerParent<WitchRenderState, WitchModel>)renderer, (ArmorModelSet<WitchModel>)modelSet, (ArmorModelSet<WitchModel>)babyModelSet, equipmentRenderer);
                }

                @Override
                public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, WitchRenderState renderState, float yRot, float xRot) {
                    if (this.val$entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                        super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        } else if (entityRenderer.getModel() instanceof VillagerModel) {
            entityRenderer.addLayer((RenderLayer)new VillagerArmorLayer((RenderLayerParent)entityRenderer, (ArmorModelSet)ModModelLayers.bake(ModModelLayers.VILLAGER_ARMOR, context.getModelSet(), VillagerModel::new), (ArmorModelSet)ModModelLayers.bake(ModModelLayers.VILLAGER_BABY_ARMOR, context.getModelSet(), VillagerModel::new), context.getEquipmentRenderer(), (EntityType)entityType){
                final /* synthetic */ EntityType val$entityType;
                {
                    this.val$entityType = entityType;
                    super((RenderLayerParent<VillagerRenderState, VillagerModel>)renderer, (ArmorModelSet<VillagerModel>)modelSet, (ArmorModelSet<VillagerModel>)babyModelSet, equipmentRenderer);
                }

                @Override
                public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, VillagerRenderState renderState, float yRot, float xRot) {
                    if (this.val$entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                        super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        } else if (entityRenderer.getModel() instanceof HumanoidModel) {
            entityRenderer.addLayer((RenderLayer)new HumanoidArmorLayer<HumanoidRenderState, HumanoidModel<HumanoidRenderState>, HumanoidModel<HumanoidRenderState>>(entityRenderer, ArmorModelSet.bake(ModModelLayers.HUMANOID_ARMOR, (EntityModelSet)context.getModelSet(), HumanoidModel::new), ArmorModelSet.bake(ModModelLayers.HUMANOID_BABY_ARMOR, (EntityModelSet)context.getModelSet(), HumanoidModel::new), context.getEquipmentRenderer()){

                public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, HumanoidRenderState renderState, float yRot, float xRot) {
                    if (entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                        super.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        }
    }
}

