/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.handler;

import fuzs.armoredfoes.ArmoredFoes;
import fuzs.armoredfoes.config.ServerConfig;
import fuzs.armoredfoes.init.ModLootTables;
import fuzs.armoredfoes.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import java.util.Collections;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public class SpawnEquipmentHandler {
    public static EventResult onEntityLoad(Entity entity, ServerLevel serverLevel, boolean isNewlySpawned) {
        if (isNewlySpawned && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            @Nullable EntitySpawnReason entitySpawnReason = EntityHelper.getMobSpawnReason((Entity)entity);
            if (entitySpawnReason != null) {
                ResourceKey<LootTable> resourceKey = ModLootTables.createEntityEquipmentTable(entity.getType());
                LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(resourceKey);
                if (lootTable != LootTable.EMPTY && SpawnEquipmentHandler.prepareEquipmentSlots(mob)) {
                    mob.equip(resourceKey, Collections.emptyMap());
                }
            }
        }
        return EventResult.PASS;
    }

    private static boolean prepareEquipmentSlots(Mob mob) {
        if (mob.getType().is(ModRegistry.DISCARDS_ORIGINAL_EQUIPMENT_ENTITY_TAG)) {
            for (EquipmentSlot equipmentSlot : ((ServerConfig)ArmoredFoes.CONFIG.get(ServerConfig.class)).clearedEquipmentSlots) {
                mob.setItemSlot(equipmentSlot, ItemStack.EMPTY);
            }
        } else {
            for (EquipmentSlot equipmentSlot : ((ServerConfig)ArmoredFoes.CONFIG.get(ServerConfig.class)).clearedEquipmentSlots) {
                if (mob.getItemBySlot(equipmentSlot).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

