/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.armoredfoes.init.ModRegistry;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record EffectiveDifficultyCheck(NumberProvider chance) implements LootItemCondition
{
    public static final MapCodec<EffectiveDifficultyCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("chance").forGetter(EffectiveDifficultyCheck::chance)).apply((Applicative)instance, EffectiveDifficultyCheck::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)ModRegistry.EFFECTIVE_DIFFICULTY_CHECK_LOOT_ITEM_CONDITION_TYPE.value();
    }

    public boolean test(LootContext context) {
        DifficultyInstance difficulty = EffectiveDifficultyCheck.getDifficulty(context);
        float f = this.chance.getFloat(context) * difficulty.getSpecialMultiplier();
        return context.getRandom().nextFloat() < f;
    }

    public Set<ContextKey<?>> getReferencedContextParams() {
        return Sets.union((Set)this.chance.getReferencedContextParams(), (Set)ImmutableSet.of((Object)LootContextParams.ORIGIN));
    }

    public static DifficultyInstance getDifficulty(LootContext context) {
        BlockPos blockPos = BlockPos.containing((Position)((Position)context.getParameter(LootContextParams.ORIGIN)));
        return context.getLevel().getCurrentDifficultyAt(blockPos);
    }

    public static LootItemCondition.Builder randomChance(float chance) {
        return () -> new EffectiveDifficultyCheck((NumberProvider)ConstantValue.exactly((float)chance));
    }

    public static LootItemCondition.Builder randomChance(NumberProvider chance) {
        return () -> new EffectiveDifficultyCheck(chance);
    }
}

