/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.armoredfoes.init.ModRegistry;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record RaidCheck(Optional<IntRange> waves) implements LootItemCondition
{
    public static final MapCodec<RaidCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntRange.CODEC.optionalFieldOf("waves").forGetter(RaidCheck::waves)).apply((Applicative)instance, RaidCheck::new));

    public LootItemConditionType getType() {
        return (LootItemConditionType)ModRegistry.RAID_CHECK_LOOT_ITEM_CONDITION_TYPE.value();
    }

    public boolean test(LootContext context) {
        Object object = context.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (object instanceof Raider) {
            Raider raider = (Raider)object;
            return raider.getCurrentRaid() != null && (this.waves.isEmpty() || this.waves.get().test(context, raider.getCurrentRaid().getGroupsSpawned()));
        }
        return false;
    }

    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.waves.map(IntRange::getReferencedContextParams).orElseGet(() -> super.getReferencedContextParams());
    }

    public static LootItemCondition.Builder raid() {
        return () -> new RaidCheck(Optional.empty());
    }

    public static LootItemCondition.Builder raid(IntRange waves) {
        return () -> new RaidCheck(Optional.of(waves));
    }
}

