/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.client.handler;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.armoredfoes.ArmoredFoes;
import fuzs.armoredfoes.client.model.geom.ModModelLayers;
import fuzs.armoredfoes.client.renderer.entity.layers.IllagerArmorLayer;
import fuzs.armoredfoes.client.renderer.entity.layers.VillagerArmorLayer;
import fuzs.armoredfoes.client.renderer.entity.layers.WitchArmorLayer;
import fuzs.armoredfoes.init.ModRegistry;
import fuzs.puzzleslib.api.client.renderer.v1.RenderPropertyKey;
import java.util.Map;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.WitchModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.IllagerRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.entity.state.WitchRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class EquipmentRenderingHandler {
    public static final RenderPropertyKey<Map<EquipmentSlot, ItemStack>> ARMOR_EQUIPMENT_RENDER_PROPERTY = new RenderPropertyKey(ArmoredFoes.id("armor_equipment"));

    public static void onExtractRenderState(Entity entity, EntityRenderState renderState, float partialTick) {
        if (!(renderState instanceof HumanoidRenderState) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.getType().is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
                    builder.put((Object)equipmentSlot, (Object)HumanoidMobRenderer.getEquipmentIfRenderable((LivingEntity)livingEntity, (EquipmentSlot)equipmentSlot));
                }
                RenderPropertyKey.set((EntityRenderState)renderState, ARMOR_EQUIPMENT_RENDER_PROPERTY, (Object)builder.build());
            }
        }
    }

    public static void addLivingEntityRenderLayers(final EntityType<?> entityType, LivingEntityRenderer<?, ?, ?> entityRenderer, EntityRendererProvider.Context context) {
        if (entityRenderer.getModel() instanceof IllagerModel) {
            entityRenderer.addLayer((RenderLayer)new IllagerArmorLayer<IllagerRenderState>(entityRenderer, new IllagerModel(context.bakeLayer(ModModelLayers.ILLAGER_INNER_ARMOR)), new IllagerModel(context.bakeLayer(ModModelLayers.ILLAGER_OUTER_ARMOR)), new IllagerModel(context.bakeLayer(ModModelLayers.ILLAGER_BABY_INNER_ARMOR)), new IllagerModel(context.bakeLayer(ModModelLayers.ILLAGER_BABY_OUTER_ARMOR)), context.getEquipmentRenderer()){

                @Override
                public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, IllagerRenderState renderState, float yRot, float xRot) {
                    if (entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                        super.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        } else if (entityRenderer.getModel() instanceof WitchModel) {
            entityRenderer.addLayer((RenderLayer)new WitchArmorLayer((RenderLayerParent)entityRenderer, new WitchModel(context.bakeLayer(ModModelLayers.WITCH_INNER_ARMOR)), new WitchModel(context.bakeLayer(ModModelLayers.WITCH_OUTER_ARMOR)), new WitchModel(context.bakeLayer(ModModelLayers.WITCH_BABY_INNER_ARMOR)), new WitchModel(context.bakeLayer(ModModelLayers.WITCH_BABY_OUTER_ARMOR)), context.getEquipmentRenderer(), (EntityType)entityType){
                final /* synthetic */ EntityType val$entityType;
                {
                    this.val$entityType = entityType;
                    super((RenderLayerParent<WitchRenderState, WitchModel>)renderer, innerModel, outerModel, innerModelBaby, outerModelBaby, equipmentRenderer);
                }

                @Override
                public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, WitchRenderState renderState, float yRot, float xRot) {
                    if (this.val$entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                        super.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        } else if (entityRenderer.getModel() instanceof VillagerModel) {
            entityRenderer.addLayer((RenderLayer)new VillagerArmorLayer((RenderLayerParent)entityRenderer, new VillagerModel(context.bakeLayer(ModModelLayers.VILLAGER_INNER_ARMOR)), new VillagerModel(context.bakeLayer(ModModelLayers.VILLAGER_OUTER_ARMOR)), new VillagerModel(context.bakeLayer(ModModelLayers.VILLAGER_BABY_INNER_ARMOR)), new VillagerModel(context.bakeLayer(ModModelLayers.VILLAGER_BABY_OUTER_ARMOR)), context.getEquipmentRenderer(), (EntityType)entityType){
                final /* synthetic */ EntityType val$entityType;
                {
                    this.val$entityType = entityType;
                    super((RenderLayerParent<VillagerRenderState, VillagerModel>)renderer, innerModel, outerModel, innerModelBaby, outerModelBaby, equipmentRenderer);
                }

                @Override
                public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, VillagerRenderState renderState, float yRot, float xRot) {
                    if (this.val$entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                        super.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        } else if (entityRenderer.getModel() instanceof HumanoidModel) {
            entityRenderer.addLayer((RenderLayer)new HumanoidArmorLayer<HumanoidRenderState, HumanoidModel<HumanoidRenderState>, HumanoidArmorModel<HumanoidRenderState>>(entityRenderer, new HumanoidArmorModel(context.bakeLayer(ModModelLayers.HUMANOID_INNER_ARMOR)), new HumanoidArmorModel(context.bakeLayer(ModModelLayers.HUMANOID_OUTER_ARMOR)), new HumanoidArmorModel(context.bakeLayer(ModModelLayers.HUMANOID_BABY_INNER_ARMOR)), new HumanoidArmorModel(context.bakeLayer(ModModelLayers.HUMANOID_BABY_OUTER_ARMOR)), context.getEquipmentRenderer()){

                public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, HumanoidRenderState renderState, float yRot, float xRot) {
                    if (entityType.is(ModRegistry.SHOWS_WORN_ARMOR_ENTITY_TAG)) {
                        super.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
                    }
                }
            });
        }
    }
}

