/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.client.model;

import net.minecraft.client.model.ZombieVillagerModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class ArmorModels {
    public static LayerDefinition createArmorLayer(CubeDeformation cubeDeformation) {
        return ZombieVillagerModel.createArmorLayer((CubeDeformation)cubeDeformation).apply(meshDefinition -> ArmorModels.modifyMesh(meshDefinition, cubeDeformation));
    }

    public static LayerDefinition createInnerArmorLayer(CubeDeformation cubeDeformation) {
        return ArmorModels.createArmorLayer(cubeDeformation).apply(meshDefinition -> ArmorModels.modifyInnerMesh(meshDefinition, cubeDeformation));
    }

    public static LayerDefinition createVillagerArmorLayer(CubeDeformation cubeDeformation) {
        return ArmorModels.createArmorLayer(cubeDeformation).apply(ArmorModels::modifyVillagerMesh);
    }

    public static LayerDefinition createInnerVillagerArmorLayer(CubeDeformation cubeDeformation) {
        return ArmorModels.createVillagerArmorLayer(cubeDeformation).apply(meshDefinition -> ArmorModels.modifyInnerMesh(meshDefinition, cubeDeformation));
    }

    public static LayerDefinition createWitchArmorLayer(CubeDeformation cubeDeformation) {
        return ArmorModels.createVillagerArmorLayer(cubeDeformation).apply(ArmorModels::modifyWitchMesh);
    }

    public static LayerDefinition createInnerWitchArmorLayer(CubeDeformation cubeDeformation) {
        return ArmorModels.createWitchArmorLayer(cubeDeformation).apply(meshDefinition -> ArmorModels.modifyInnerMesh(meshDefinition, cubeDeformation));
    }

    private static MeshDefinition modifyMesh(MeshDefinition meshDefinition, CubeDeformation cubeDeformation) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation.extend(0.1f, 0.1f, 0.6f)), PartPose.ZERO);
        PartDefinition partDefinition3 = partDefinition.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partDefinition3.addOrReplaceChild("right_shoulder", CubeListBuilder.create().texOffs(40, 16).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, cubeDeformation), PartPose.ZERO);
        partDefinition3.addOrReplaceChild("left_shoulder", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, cubeDeformation), PartPose.ZERO);
        return meshDefinition;
    }

    private static MeshDefinition modifyVillagerMesh(MeshDefinition meshDefinition) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.clearChild("right_arm");
        partDefinition.clearChild("left_arm");
        return meshDefinition;
    }

    private static MeshDefinition modifyWitchMesh(MeshDefinition meshDefinition) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition partDefinition2 = partDefinition.clearChild("head");
        partDefinition2.addOrReplaceChild("nose", CubeListBuilder.create(), PartPose.ZERO);
        return meshDefinition;
    }

    private static MeshDefinition modifyInnerMesh(MeshDefinition meshDefinition, CubeDeformation cubeDeformation) {
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation.extend(-0.2f, 0.1f, 0.1f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation.extend(-0.2f, 0.1f, 0.1f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        return meshDefinition;
    }
}

