/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.data.loot;

import fuzs.armoredfoes.init.ModLootTables;
import fuzs.armoredfoes.world.level.storage.loot.entries.SelectionEntry;
import fuzs.armoredfoes.world.level.storage.loot.entries.UnpackingSequenceEntry;
import fuzs.armoredfoes.world.level.storage.loot.functions.ApplyEnchantmentProviderFunction;
import fuzs.armoredfoes.world.level.storage.loot.predicates.DifficultyCheck;
import fuzs.armoredfoes.world.level.storage.loot.predicates.EffectiveDifficultyCheck;
import fuzs.armoredfoes.world.level.storage.loot.predicates.RaidCheck;
import fuzs.puzzleslib.api.data.v2.AbstractLootProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;

public class ModEquipmentLootProvider
extends AbstractLootProvider.Simple {
    public ModEquipmentLootProvider(DataProviderContext context) {
        super(LootContextParamSets.EQUIPMENT, context);
    }

    public void addLootTables() {
        this.add(ModLootTables.NATURAL_ARMOR_EQUIPMENT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)new SelectionEntry.Builder(new LootPoolEntryContainer.Builder[]{NestedLootTable.lootTableReference(ModLootTables.LEATHER_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.COPPER_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.GOLDEN_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.CHAINMAIL_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.IRON_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.DIAMOND_ARMOR_EQUIPMENT)}))));
        this.add(ModLootTables.RAIDER_ARMOR_EQUIPMENT, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)new SelectionEntry.Builder(new LootPoolEntryContainer.Builder[]{NestedLootTable.lootTableReference(ModLootTables.GOLDEN_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.CHAINMAIL_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.IRON_ARMOR_EQUIPMENT), NestedLootTable.lootTableReference(ModLootTables.DIAMOND_ARMOR_EQUIPMENT)}))));
        this.add(ModLootTables.LEATHER_ARMOR_EQUIPMENT, this.createArmorEquipment(Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS));
        this.add(ModLootTables.COPPER_ARMOR_EQUIPMENT, this.createArmorEquipment(Items.COPPER_HELMET, Items.COPPER_CHESTPLATE, Items.COPPER_LEGGINGS, Items.COPPER_BOOTS));
        this.add(ModLootTables.GOLDEN_ARMOR_EQUIPMENT, this.createArmorEquipment(Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS));
        this.add(ModLootTables.CHAINMAIL_ARMOR_EQUIPMENT, this.createArmorEquipment(Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS));
        this.add(ModLootTables.IRON_ARMOR_EQUIPMENT, this.createArmorEquipment(Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS));
        this.add(ModLootTables.DIAMOND_ARMOR_EQUIPMENT, this.createArmorEquipment(Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS));
        this.addNaturalArmorTable(EntityType.WITHER_SKELETON);
        this.addNaturalArmorTable(EntityType.DROWNED);
        this.addGoldenArmorTable(EntityType.PIGLIN);
        this.addGoldenArmorTable(EntityType.PIGLIN_BRUTE);
        this.addGoldenArmorTable(EntityType.ZOMBIFIED_PIGLIN);
        this.addRaiderArmorTable(EntityType.VINDICATOR);
        this.addRaiderArmorTable(EntityType.EVOKER);
        this.addRaiderArmorTable(EntityType.ILLUSIONER);
        this.addRaiderArmorTable(EntityType.PILLAGER);
    }

    private void addNaturalArmorTable(EntityType<?> entityType) {
        this.add(ModLootTables.createEntityEquipmentTable(entityType), LootTable.lootTable().withPool(LootPool.lootPool().add(NestedLootTable.lootTableReference(ModLootTables.NATURAL_ARMOR_EQUIPMENT).when(EffectiveDifficultyCheck.randomChance(0.15f)))));
    }

    private void addGoldenArmorTable(EntityType<?> entityType) {
        this.add(ModLootTables.createEntityEquipmentTable(entityType), LootTable.lootTable().withPool(LootPool.lootPool().add(((LootPoolSingletonContainer.Builder)NestedLootTable.lootTableReference(ModLootTables.GOLDEN_ARMOR_EQUIPMENT).when(LootItemRandomChanceCondition.randomChance((float)0.1f))).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setIsBaby(Boolean.valueOf(false))))))));
    }

    private void addRaiderArmorTable(EntityType<?> entityType) {
        this.add(ModLootTables.createEntityEquipmentTable(entityType), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{((LootPoolSingletonContainer.Builder)NestedLootTable.lootTableReference(ModLootTables.RAIDER_ARMOR_EQUIPMENT).when(LootItemRandomChanceCondition.randomChance((float)0.65f))).when(RaidCheck.raid(IntRange.lowerBound((int)6))), ((LootPoolSingletonContainer.Builder)NestedLootTable.lootTableReference(ModLootTables.RAIDER_ARMOR_EQUIPMENT).when(LootItemRandomChanceCondition.randomChance((float)0.35f))).when(RaidCheck.raid(IntRange.range((int)3, (int)5))), NestedLootTable.lootTableReference(ModLootTables.RAIDER_ARMOR_EQUIPMENT).when(LootItemRandomChanceCondition.randomChance((float)0.15f))}))));
    }

    private LootTable.Builder createArmorEquipment(Item headItem, Item chestItem, Item legsItem, Item feetItem) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)new UnpackingSequenceEntry.Builder(new LootPoolEntryContainer.Builder[]{this.createEnchantedSpawnedArmor(headItem), this.createArmorEquipmentPiece(chestItem), this.createArmorEquipmentPiece(legsItem), this.createArmorEquipmentPiece(feetItem)})));
    }

    private LootPoolEntryContainer.Builder<?> createArmorEquipmentPiece(Item item) {
        return AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{((LootPoolSingletonContainer.Builder)this.createEnchantedSpawnedArmor(item).when(LootItemRandomChanceCondition.randomChance((float)0.9f))).when(DifficultyCheck.difficulty(Difficulty.HARD)), ((LootPoolSingletonContainer.Builder)this.createEnchantedSpawnedArmor(item).when(LootItemRandomChanceCondition.randomChance((float)0.75f))).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)DifficultyCheck.difficulty(Difficulty.HARD)))});
    }

    private LootPoolSingletonContainer.Builder<?> createEnchantedSpawnedWeapon(Item item) {
        return this.createSpawnedEquipment(item, 0.25f);
    }

    private LootPoolSingletonContainer.Builder<?> createEnchantedSpawnedArmor(Item item) {
        return this.createSpawnedEquipment(item, 0.5f);
    }

    private LootPoolSingletonContainer.Builder<?> createSpawnedEquipment(Item item, float randomChance) {
        return LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)ApplyEnchantmentProviderFunction.fromProvider(this.registries(), (ResourceKey<EnchantmentProvider>)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT).when(EffectiveDifficultyCheck.randomChance(randomChance)));
    }
}

