/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.armoredfoes.init.ModRegistry;
import java.util.List;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class SelectionEntry
extends CompositeEntryBase {
    public static final MapCodec<SelectionEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootPoolEntries.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(entry -> entry.children)).and(SelectionEntry.commonFields((RecordCodecBuilder.Instance)instance).t1()).and((App)NumberProviders.CODEC.fieldOf("base").forGetter(entry -> entry.base)).and((App)NumberProviders.CODEC.fieldOf("per_value_above_first").forGetter(entry -> entry.perValueAboveFirst)).apply((Applicative)instance, SelectionEntry::new));
    private final NumberProvider base;
    private final NumberProvider perValueAboveFirst;

    public SelectionEntry(List<LootPoolEntryContainer> children, List<LootItemCondition> conditions) {
        this(children, conditions, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f), (NumberProvider)ConstantValue.exactly((float)0.095f));
    }

    public SelectionEntry(List<LootPoolEntryContainer> children, List<LootItemCondition> conditions, NumberProvider base, NumberProvider perValueAboveFirst) {
        super(children, conditions);
        this.base = base;
        this.perValueAboveFirst = perValueAboveFirst;
    }

    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> children) {
        if (children.isEmpty()) {
            return ALWAYS_FALSE;
        }
        return (context, consumer) -> {
            int equipmentTier = this.getEquipmentTier(context, children.size() - 1);
            return ((ComposableEntryContainer)children.get(equipmentTier)).expand(context, consumer);
        };
    }

    protected int getEquipmentTier(LootContext context, int tiers) {
        int equipmentTier = this.base.getInt(context);
        for (int i = 0; i < tiers; ++i) {
            if (!(context.getRandom().nextFloat() < this.perValueAboveFirst.getFloat(context))) continue;
            ++equipmentTier;
        }
        return Math.min(equipmentTier, tiers);
    }

    public LootPoolEntryType getType() {
        return (LootPoolEntryType)ModRegistry.SELECTION_LOOT_POOL_ENTRY_TYPE.value();
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();

        public Builder(LootPoolEntryContainer.Builder<?> ... children) {
            for (LootPoolEntryContainer.Builder<?> builder : children) {
                this.entries.add((Object)builder.build());
            }
        }

        protected Builder getThis() {
            return this;
        }

        public Builder and(LootPoolEntryContainer.Builder<?> childBuilder) {
            this.entries.add((Object)childBuilder.build());
            return this.getThis();
        }

        public LootPoolEntryContainer build() {
            return new SelectionEntry((List<LootPoolEntryContainer>)this.entries.build(), this.getConditions());
        }
    }
}

