/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.armoredfoes.init.ModRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.ComposableEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.SequentialEntry;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class UnpackingSequenceEntry
extends SequentialEntry {
    public static final MapCodec<UnpackingSequenceEntry> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootPoolEntries.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(entry -> entry.children)).and(UnpackingSequenceEntry.singletonFields((RecordCodecBuilder.Instance<UnpackingSequenceEntry>)instance)).apply((Applicative)instance, UnpackingSequenceEntry::new));
    protected final int weight;
    protected final int quality;
    protected final List<LootItemFunction> functions;
    final BiFunction<ItemStack, LootContext, ItemStack> compositeFunction;

    public UnpackingSequenceEntry(List<LootPoolEntryContainer> children, int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions) {
        super(children, conditions);
        this.weight = weight;
        this.quality = quality;
        this.functions = functions;
        this.compositeFunction = LootItemFunctions.compose(functions);
    }

    protected static Products.P4<RecordCodecBuilder.Mu<UnpackingSequenceEntry>, Integer, Integer, List<LootItemCondition>, List<LootItemFunction>> singletonFields(RecordCodecBuilder.Instance<UnpackingSequenceEntry> instance) {
        return instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(container -> container.weight), (App)Codec.INT.optionalFieldOf("quality", (Object)0).forGetter(lootPoolSingletonContainer -> lootPoolSingletonContainer.quality)).and(UnpackingSequenceEntry.commonFields(instance).t1()).and((App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(container -> container.functions));
    }

    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> children) {
        return (context, consumer) -> {
            final ArrayList lootPoolEntries = new ArrayList();
            consumer.accept(new LootPoolEntry(){

                public int getWeight(float luck) {
                    return Math.max(Mth.floor((float)((float)UnpackingSequenceEntry.this.weight + (float)UnpackingSequenceEntry.this.quality * luck)), 0);
                }

                public void createItemStack(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
                    for (LootPoolEntry lootPoolEntry : lootPoolEntries) {
                        lootPoolEntry.createItemStack(LootItemFunction.decorate(UnpackingSequenceEntry.this.compositeFunction, stackConsumer, (LootContext)lootContext), lootContext);
                    }
                }
            });
            return UnpackingSequenceEntry.super.compose(children).expand(context, lootPoolEntries::add);
        };
    }

    public void validate(ValidationContext validationContext) {
        super.validate(validationContext);
        for (int i = 0; i < this.functions.size(); ++i) {
            this.functions.get(i).validate(validationContext.forChild((ProblemReporter.PathElement)new ProblemReporter.IndexedFieldPathElement("functions", i)));
        }
    }

    public LootPoolEntryType getType() {
        return (LootPoolEntryType)ModRegistry.UNPACKING_SEQUENCE_LOOT_POOL_ENTRY_TYPE.value();
    }

    public static class Builder
    extends LootPoolEntryContainer.Builder<Builder>
    implements FunctionUserBuilder<Builder> {
        private final ImmutableList.Builder<LootPoolEntryContainer> entries = ImmutableList.builder();
        protected int weight = 1;
        protected int quality = 0;
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();

        public Builder(LootPoolEntryContainer.Builder<?> ... children) {
            for (LootPoolEntryContainer.Builder<?> builder : children) {
                this.entries.add((Object)builder.build());
            }
        }

        protected Builder getThis() {
            return this;
        }

        public Builder apply(LootItemFunction.Builder functionBuilder) {
            this.functions.add((Object)functionBuilder.build());
            return this.getThis();
        }

        public Builder and(LootPoolEntryContainer.Builder<?> childBuilder) {
            this.entries.add((Object)childBuilder.build());
            return this.getThis();
        }

        protected List<LootItemFunction> getFunctions() {
            return this.functions.build();
        }

        public Builder setWeight(int weight) {
            this.weight = weight;
            return this.getThis();
        }

        public Builder setQuality(int quality) {
            this.quality = quality;
            return this.getThis();
        }

        public LootPoolEntryContainer build() {
            return new UnpackingSequenceEntry((List<LootPoolEntryContainer>)this.entries.build(), this.weight, this.quality, this.getConditions(), this.getFunctions());
        }
    }
}

