/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public abstract class LivingArmorLayer<S extends LivingEntityRenderState, M extends EntityModel<S>, A extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final ArmorModelSet<A> modelSet;
    private final ArmorModelSet<A> babyModelSet;
    private final EquipmentLayerRenderer equipmentRenderer;

    public LivingArmorLayer(RenderLayerParent<S, M> renderer, ArmorModelSet<A> modelSet, EquipmentLayerRenderer equipmentRenderer) {
        this(renderer, modelSet, modelSet, equipmentRenderer);
    }

    public LivingArmorLayer(RenderLayerParent<S, M> renderer, ArmorModelSet<A> modelSet, ArmorModelSet<A> babyModelSet, EquipmentLayerRenderer equipmentRenderer) {
        super(renderer);
        this.modelSet = modelSet;
        this.babyModelSet = babyModelSet;
        this.equipmentRenderer = equipmentRenderer;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, S renderState, float yRot, float xRot) {
        this.renderArmorPiece(poseStack, nodeCollector, EquipmentSlot.CHEST, packedLight, renderState);
        this.renderArmorPiece(poseStack, nodeCollector, EquipmentSlot.LEGS, packedLight, renderState);
        this.renderArmorPiece(poseStack, nodeCollector, EquipmentSlot.FEET, packedLight, renderState);
        this.renderArmorPiece(poseStack, nodeCollector, EquipmentSlot.HEAD, packedLight, renderState);
    }

    private void renderArmorPiece(PoseStack poseStack, SubmitNodeCollector nodeCollector, EquipmentSlot slot, int packedLight, S renderState) {
        ItemStack item = this.getItem(renderState, slot);
        Equippable equippable = (Equippable)item.get(DataComponents.EQUIPPABLE);
        if (equippable != null && HumanoidArmorLayer.shouldRender((Equippable)equippable, (EquipmentSlot)slot)) {
            A humanoidModel = this.getArmorModel(renderState, slot);
            EquipmentClientInfo.LayerType layerType = this.usesInnerModel(slot) ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
            this.equipmentRenderer.renderLayers(layerType, (ResourceKey)equippable.assetId().orElseThrow(), humanoidModel, renderState, item, poseStack, nodeCollector, packedLight, ((LivingEntityRenderState)renderState).outlineColor);
        }
    }

    protected abstract ItemStack getItem(S var1, EquipmentSlot var2);

    private A getArmorModel(S renderState, EquipmentSlot slot) {
        return (A)((EntityModel)(((LivingEntityRenderState)renderState).isBaby ? this.babyModelSet : this.modelSet).get(slot));
    }

    private boolean usesInnerModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }
}

