/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armoredfoes.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.armoredfoes.init.ModRegistry;
import fuzs.armoredfoes.world.level.storage.loot.predicates.EffectiveDifficultyCheck;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ApplyEnchantmentProviderFunction
extends LootItemConditionalFunction {
    public static final MapCodec<ApplyEnchantmentProviderFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> ApplyEnchantmentProviderFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryFixedCodec.create((ResourceKey)Registries.ENCHANTMENT_PROVIDER).fieldOf("provider").forGetter(function -> function.provider)).t1()).apply((Applicative)instance, ApplyEnchantmentProviderFunction::new));
    private final Holder<EnchantmentProvider> provider;

    public ApplyEnchantmentProviderFunction(List<LootItemCondition> predicates, Holder<EnchantmentProvider> provider) {
        super(predicates);
        this.provider = provider;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)ModRegistry.APPLY_ENCHANTMENT_PROVIDER_LOOT_FUNCTION_TYPE.value();
    }

    protected ItemStack run(ItemStack itemStack, LootContext context) {
        RegistryAccess registryAccess = context.getLevel().registryAccess();
        DifficultyInstance difficulty = EffectiveDifficultyCheck.getDifficulty(context);
        EnchantmentHelper.enchantItemFromProvider((ItemStack)itemStack, (RegistryAccess)registryAccess, (ResourceKey)((ResourceKey)this.provider.unwrapKey().orElseThrow()), (DifficultyInstance)difficulty, (RandomSource)context.getRandom());
        return itemStack;
    }

    public static Builder fromProvider(HolderLookup.Provider registries, ResourceKey<EnchantmentProvider> resourceKey) {
        return new Builder((Holder<EnchantmentProvider>)registries.lookupOrThrow(Registries.ENCHANTMENT_PROVIDER).getOrThrow(resourceKey));
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Holder<EnchantmentProvider> provider;

        public Builder(Holder<EnchantmentProvider> provider) {
            this.provider = provider;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new ApplyEnchantmentProviderFunction(this.getConditions(), this.provider);
        }
    }
}

