let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

// Add custom ability
StartupEvents.registry('palladium:abilities', (event) => {

    // ID of the ability will be: 'kubejs:jump/boost'
    event.create('elementia:anti_swim')

    .icon(palladium.createItemIcon('minecraft:diamond'))
    .addProperty("motion_scale", "float", 0.1, "Motion Scale")
    .documentationDescription('Propells you downwards, sinking you.')

    .tick((entity, entry, holder, enabled) => {
      if (enabled) {
        let motionscale = entry.getPropertyByName("motion_scale")
        let motion = entity.getDeltaMovement().multiply(1, 0, 1).add(0, motionscale, 0);
        entity.setDeltaMovement(motion);

        if (entity.isPlayer()) {
          entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
        }
      }
    })
});

