StartupEvents.registry("palladium:abilities", event => {
    event.create("elementia:command_at_block")
        .icon(palladium.createItemIcon('minecraft:command_block'))
        .documentationDescription('Runs a command at the position of a targeted block if it has a specific block tag and is above a minimum y-level.')
        .addProperty("range", "float", 16.0, "Maximum distance to target a block")
        .addProperty("block_tag", "string", "#minecraft:logs", "Block tags that will execute the command. Use 'any' for any block")
        .addProperty("command", "string", "null", "Command executed at block")
        .addProperty("min_y_level", "float", -60.0, "Minimum y-level for the block to execute the command.")
        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                let username = entity.getGameProfile().getName();
                let range = entry.getPropertyByName('range');
                let block_tag = entry.getPropertyByName('block_tag');
                let command = entry.getPropertyByName('command');
                let min_y_level = entry.getPropertyByName('min_y_level');

                let rayTrace = entity.rayTrace(range);
                if (rayTrace.block === null) return;

                let block = rayTrace.block;
                let blockPos = block.pos;

                // Check if block is above min_y_level
                if (blockPos.y < min_y_level) return;

                if (block.hasTag(block_tag) || block_tag === "any") {
                    entity.server.runCommandSilent(`execute at ${username} positioned ${blockPos.x} ${blockPos.y} ${blockPos.z} run ${command}`);
                }
            }
        });
});