(function () {
    StartupEvents.registry('palladium:abilities', event => {
        event.create('elementia:element_detection')
            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('range', 'float', 10.0, 'The range within which the effect will be granted')

            .tick((entity, entry, holder, enabled) => {
                if (!enabled) return;

                let range = entry.getPropertyByName('range');
                let target = entity.rayTrace(range).entity;

                let blacklist = [
                    'p_sing:effects/charged',
                    'p_sing:effects/dampened',
                    'p_sing:effects/decimated',
                    'p_sing:effects/disorientated',
                    'p_sing:effects/downwards',
                    'p_sing:effects/drowned',
                    'p_sing:effects/energy_shock',
                    'p_sing:effects/esper_telekinesis',
                    'p_sing:effects/exhaustion',
                    'p_sing:effects/exploded',
                    'p_sing:effects/feared',
                    'p_sing:effects/freeze',
                    'p_sing:effects/frozen',
                    'p_sing:effects/implosion',
                    'p_sing:effects/matter_warning',
                    'p_sing:effects/molecule_unstable',
                    'p_sing:effects/overheated',
                    'p_sing:effects/poison',
                    'p_sing:effects/pushed',
                    'p_sing:effects/shadow_marked',
                    'p_sing:effects/shocked',
                    'p_sing:effects/shutdown',
                    'p_sing:effects/soaked',
                    'p_sing:effects/soul_snatch',
                    'p_sing:effects/spectrum',
                    'p_sing:effects/telekinesis_throw',
                    'p_sing:effects/thunder_shock',
                    'p_sing:effects/time_forward',
                    'p_sing:effects/time_slow',
                    'p_sing:effects/time_stop',
                    'p_sing:effects/titan_death',
                    'p_sing:base_power',
                    'elementia:effects/basic/meditation',
                    'elementia:effects/basic/inner_potential',
                    'elementia:base',
                    'elementia:base_elemental',

                ];

                if (target && target.isAlive() && target != entity) {
                    let powers = palladium.powers.getPowerIds(target);
                    entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Player: ","color":"gold"},{"text":"${target.name.string}","color":"yellow"}]`);

                    powers.forEach(power => {
                        let powerId = power.toString();
                        if (!blacklist.includes(powerId)) {
                            entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Power: ","color":"gold"},{"text":"${powerId}","color":"yellow"}]`);
                        }
                    });
                }
            });
    });
})();
