// Register the custom condition to detect if a player is at or above a specific Y coordinate
StartupEvents.registry('palladium:condition_serializer', (event) => {
  event.create('elementia:height_level')
    .addProperty("y_level", "integer", 100, "The Y coordinate to check against")
    .test((entity, props) => {
      let yLevel = props.get("y_level");
      return entity.getY() >= yLevel;  // Return true if the player's Y coordinate is at or above the specified value
    });
});
