StartupEvents.registry('palladium:abilities', (event) => {
    event.create('elementia:mana_modification')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('Increases or decreases of x% mana replenishment')
        .addProperty("operation", "string", "add", "additions or removals")
        .addProperty("percentage", "integer", 20, "Percentage modified")
        .firstTick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                let username = entity.getGameProfile().getName();
                let operation = entry.getPropertyByName('operation');
                let percentage = entry.getPropertyByName('percentage')/100;
                let manaOperation;

                // Retrieve positions
                let mana_max = parseInt(entity.server.runCommandSilent(`scoreboard players get ${username} Elementia.Mana.Max`))|| 0;
                let mana_regen = mana_max * 0.0075 * percentage ;
                

                // Ensure mana_regen is at least 1 and round it
                mana_regen = Math.ceil(Math.max(1, mana_regen));

                // Subtract mana_regen
                let success = entity.server.runCommandSilent(`scoreboard players ${operation} ${username} Elementia.Mana ${mana_regen}`);
                if (!success) {
                    console.log(`Failed to update mana for player ${username}`);
                }
            }
        })
});


   



