StartupEvents.registry('palladium:abilities', (event) => {
    event.create('elementia:mastery_gain')
        .addProperty('amount', 'integer', 1, 'The amount of mastery to gain when this ability is used')
        .addProperty('element', 'string', 'flame', 'The tag of the elements affinity to check for')
        .addProperty('neg_element', 'string', 'negflame', 'The tag of the elements affinity that will reduce mastery gain')
        .addProperty('mastery', 'string', 'elementia.flameMastery', 'The name of the elements mastery SCORE scoreboard')
        .addProperty('pos_multiplier', 'integer', 1.5, 'The multiplier to apply if the entity has the positive affinity')
        .addProperty('neg_multiplier', 'integer', 2, 'The multiplier to apply if the entity has the negative affinity. Higher values mean less gain')
        .addProperty('level_multiplier', 'float', 0.1, 'The multiplier to apply based on the entities current level in this element')
        .addProperty('element_level', 'string', 'elementia.flameLevel', 'The name of the elements mastery LEVEL scoreboard')

        .tick((entity, entry, holder, enabled) => {
            let firstamount = Math.floor(entry.getPropertyByName('amount') * entry.getPropertyByName('level_multiplier') * palladium.scoreboard.getScore(entity, entry.getPropertyByName('element_level')))
            let posmult = entry.getPropertyByName('pos_multiplier')
            let negmult = entry.getPropertyByName('neg_multiplier')
            let posamount = Math.floor(firstamount * posmult)
            let negamount = Math.floor(firstamount / negmult)
            let element = entry.getPropertyByName('element')
            let neg_element = entry.getPropertyByName('neg_element')
            let mastery = entry.getPropertyByName('mastery')
            if (enabled) {
                if (entity.tags.contains(element)) {
                    palladium.scoreboard.addScore(entity, mastery, posamount)
                }
                else if (entity.tags.contains(neg_element)) {
                    palladium.scoreboard.addScore(entity, mastery, negamount)
                }
                else {
                    palladium.scoreboard.addScore(entity, mastery, firstamount)
                }
            }
        })
})