StartupEvents.registry('palladium:abilities', (event) => {
    event.create('elementia:stop_mana')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .firstTick((entity, entry, holder, enabled) => {
            if (abilityUtil.isEnabled(entity, 'elementia:effect/basic/stop_mana_regeneration', 'mana_regen_stop') && entity.isPlayer()) {
                let username = entity.getGameProfile().getName();
                entity.getPersistentData().putString("user", username);

                // Retrieve positions
                let mana_max = parseInt(entity.server.runCommandSilent(`scoreboard players get ${username} Elementia.Mana.Max`)) || 0;
                let mana_regen = 0;
                if (mana_max >= 2000){
                    mana_regen = 40
                }
                else{
                    mana_regen = mana_max * 0.0075;
                }
                

                // Ensure mana_regen is at least 1 and round it
                mana_regen = Math.ceil(Math.max(1, mana_regen));

                // Subtract mana_regen
                let success = entity.server.runCommandSilent(`scoreboard players remove ${username} Elementia.Mana ${mana_regen}`);
                if (!success) {
                    console.log(`Failed to update mana for player ${username}`);
                }
            }
        })
        .lastTick((entity, entry, holder, enabled) => {
            if (enabled) {
                // Logic for the last tick
            }
        });
});


   



