StartupEvents.registry('palladium:abilities', (event) => {

    event.create('elementia:wood_detect')

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('Changes the material for wooden rocks or abilities. Only useful for Earth Elemental')

        .addProperty('score', 'string', 'scoreboard_name', 'the scoreboard that the type is put in')
        .addProperty('needs', 'integer', 6, 'the required amount of any 1 block')

        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                const score = entry.getPropertyByName('score');
                const needs = entry.getPropertyByName('needs');
                let username = entity.getGameProfile().getName();
                let username_true = username.toLowerCase();

                let max_type = global.material_wood_types;

                for (let types = 0; types <= max_type; types++) {
                    entity.persistentData['wood_type_' + types] = 0
                }

                for (let pos of BlockPos.betweenClosed(new BlockPos(entity.x + 5, entity.y + 5, entity.z + 5), [entity.x - 5, entity.y - 5, entity.z - 5])) {

                    for (let types = 0; types <= max_type; types++) {
                        let material_type = global['wood_type_' + types].toString();
                        console.log("Material type is:"+material_type);
                        if (entity.getLevel().getBlock(pos).id === material_type) {
                            entity.persistentData['wood_type_' + types] = entity.persistentData['wood_type_' + types] + 1
                        }
                    }
                }
                // select rock type
                let check_type = -1
                for (let types = 0; types <= max_type; types++) {
                    let total = entity.persistentData['wood_type_' + types]
                    if (total >= needs) {
                        if (types > check_type) {
                            check_type = types
                        }
                    }
                }
                entity.server.runCommandSilent("execute as " + username + " at @s run scoreboard players set @s " + score + " " + check_type + "");

            }
        })
});
