// Event for registering HUDs
PalladiumEvents.registerGuiOverlays((event) => {
        event.register(
                'elementia:display_id', // this can be anything, its just the registry
                (minecraft, gui, poseStack, partialTick, screenWidth, screenHeight) => {
                        let player = minecraft.player;
                        if (!player) return;


                        if (abilityUtil.hasPower(player, 'elementia:base_elemental')) {
                                poseStack.pose().pushPose();
                                poseStack.pose().translate(0, 0, 1);

                                //change these two values for the placement, this should make them roughly the middle of the screen
                                let screenXplacement = (screenWidth / 26
                                )
                                let screenYplacement = (screenHeight / 18)

                                //for when you want the mana bar to actually function instead of just look pretty
                                //these scoreboards also need to be declared in the tracked_scores.json :D
                                let mana = palladium.scoreboard.getScore(player, 'Elementia.Mana', 1)
                                let mana_max_persdata = player.persistentData.elementiaMaxMana || 100;
                                let mana_max = palladium.scoreboard.getScore(player, 'Elementia.Mana.Max', mana_max_persdata)

                                //swap the 90 with the pixels in length that your bar is (not the length that the mana bar texture is)
                                let mana_visual = Math.round((mana / mana_max) * 114)


                                //main background
                                guiUtil.blit(
                                        new ResourceLocation('elementia:textures/gui/ability_bars/sandstone_mana_bar.png'),
                                        poseStack,
                                        screenXplacement, screenYplacement,
                                        0, 0, //where the game should start reading from on the texture
                                        128, 32, //where the game stops reading from on the texture
                                        128, 32 //ngl never really worked out what this does, i just keep it as the full texture size
                                );
                                //actual mana bar
                                guiUtil.blit(
                                        new ResourceLocation(`elementia:textures/gui/ability_bars/mana_bar.png`),
                                        poseStack,
                                        screenXplacement + 6, screenYplacement + 13, // you can do + and - on this to change the location, will be needed
                                        7, 13, // youll probably want to change this to be where the bar actually stars in your texture
                                        mana_visual, 22, //swap 128 with mana_visual + whatever the first 0 is in the line above, swap 32 with where the bottom of the bar is
                                        128, 32 //again no idea at all what this stuff does
                                );
                                //you will probably want to tweak the actual mana bar a lot for it to actually work in game how you want

                                poseStack.pose().popPose();
                        }
                }
        );
});
