PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/ground_pound', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:strength", "ground_pound")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:strength', 'ground_pound', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('head')
                    .setX(0)
                    .setY(0.5)
                    .setZ(-2)
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setX(-4)
                    .setY(5)
                    .setZ(-3)
                    .setXRotDegrees(0)
                    .setYRotDegrees(-77.5)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(54)
                    .setYRotDegrees(-12)
                    .setZRotDegrees(-16)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(2)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(5)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/inner_block', 15, (builder) => {
        let animation_block = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:inner_will', 'block_ability', builder.getPartialTicks());
        if (animation_block > 0 && !builder.isFirstPerson()) {
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(-50)
                .setZRotDegrees(-70)
                .animate('InOutCubic', animation_block);

            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(50)
                .setZRotDegrees(70)
                .animate('InOutCubic', animation_block);

        }
        if (animation_block > 0.0 && builder.isFirstPerson()) {
            // do first-person animations
            builder.get('right_arm').setXRotDegrees(-55).setYRotDegrees(15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
            builder.get('left_arm').setXRotDegrees(-55).setYRotDegrees(-15).setZRotDegrees(0).setY(1).setZ(-3).animate('InOutCubic', animation_block);
        } else {
            // do third-person animations
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/will_awaken', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:items/mana_scroll', 'awaken_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/flame_awaken', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:items/flame_scroll', 'awaken_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/nature_awaken', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:items/nature_scroll', 'awaken_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/earth_awaken', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:items/earth_scroll', 'awaken_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/wind_awaken', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:items/wind_scroll', 'awaken_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/lightning_awaken', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:items/lightning_scroll', 'awaken_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/sonic_swim', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:water', 'sonic_swim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/water_awaken', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:items/water_scroll', 'awaken_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-30).setZRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-50).setZRotDegrees(-40).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-30).setZRotDegrees(50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-50).setZRotDegrees(40).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/cleanse', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:inner_will', 'cleanse_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-8).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-18).moveZ(2).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/nature_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:nature", "wood_whirl_animation")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:nature', 'wood_whirl_animation', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/nature_spin2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:nature', 'wood_whirl_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).scaleY(3).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).scaleY(3).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/nature_spin3', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:nature", "wood_whirl_animation_golem")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:nature', 'wood_whirl_animation_golem', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/nature_spin4', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:nature', 'wood_whirl_animation_golem', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(40).scaleY(6).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-40).scaleY(6).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/rooted_punch', 2, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:nature', 'rooted_punch_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').scaleY(6).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').scaleY(6).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/vine_restrain', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:nature', 'vine_restrain_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(5).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-5).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-10).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-20).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/whirlpool_summon', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:water", "whirlpool_summon")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:water', 'whirlpool', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-6)
                    .animate('InOutCubic', animation_1);

                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-3)
                    .setXRotDegrees(17.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(25)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(-25)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2.15)
                    .setY(12)
                    .setZ(-4)
                    .setXRotDegrees(77.5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2.1500000000000004)
                    .setY(8)
                    .setZ(-1)
                    .setXRotDegrees(-5)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

            }
        }
    }
    );
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/lightning_clap', 1, (builder) => {

        let air_clap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:lightning', 'barrage_clap', builder.getPartialTicks(), 6, 9);
        if (air_clap > 0 && !builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setXRotDegrees(-90)
                .setZRotDegrees(0)
                .setYRotDegrees(-30)
                .animate('InOutCubic', air_clap);

        }
        if (air_clap > 0.0 && builder.isFirstPerson()) {
            builder.get('left_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(70)
                .animate('InOutCubic', air_clap);

            builder.get('right_arm')
                .setX(0)
                .setY(3)
                .setZ(0)
                .setXRotDegrees(-30)
                .setYRotDegrees(0)
                .setZRotDegrees(-70)
                .animate('InOutCubic', air_clap);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/puddle', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:water", "puddle")) {
            const progress_buff_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:water', 'puddle', builder.getPartialTicks());
            if (progress_buff_1 > 0.0 && !builder.isFirstPerson()) {

                builder.get('head').scaleY(0.02).moveY(26).animate('InOutCubic', progress_buff_1);

                builder.get('chest')
                    .scaleY(0.02).moveY(26).animate('InOutCubic', progress_buff_1);


                builder.get('right_arm')
                    .scaleY(0.02).moveY(25).animate('InOutCubic', progress_buff_1);

                builder.get('left_arm')
                    .scaleY(0.02).moveY(25).animate('InOutCubic', progress_buff_1);

                builder.get('left_leg').scaleY(0.02).moveY(14).animate('InOutCubic', progress_buff_1);

                builder.get('right_leg').scaleY(0.02).moveY(14).animate('InOutCubic', progress_buff_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/tornado_body_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:wind", "tornado_transform_animation")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:wind', 'tornado_transform_animation', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/inner_will_spin', 2, (builder) => {

        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:inner_will", "constant_spin")) {
            const progress_spin = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:inner_will', 'constant_spin', builder.getPartialTicks(), 3, 16);
            if (progress_spin > 0.0 && !builder.isFirstPerson()) {

                builder.get('body').rotateYDegrees(-720).animate('InOutCubic', progress_spin);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/inner_will_spin2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:inner_will', 'constant_spin', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/gate_crash_anim', 2, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:lightning", "gate_crash_anim")) {
            let animation_1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:lightning', 'gate_crash_anim', builder.getPartialTicks(), 1, 4);
            if (animation_1 > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .moveY(-8)
                    .animate('InOutCubic', animation_1);
                builder.get('chest')
                    .setX(0)
                    .setY(0)
                    .setZ(-2)
                    .setXRotDegrees(65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('right_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('left_arm')
                    .setY(5)
                    .setZ(-2)
                    .animate('InOutCubic', animation_1);

                builder.get('right_leg')
                    .setX(-2)
                    .setY(4)
                    .setZ(5)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);

                builder.get('left_leg')
                    .setX(2)
                    .setY(5)
                    .setZ(8)
                    .setXRotDegrees(30)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', animation_1);
            }
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/fire_slam_0', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:flame', 'blaze_column_detonate', builder.getPartialTicks());

        if (builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutBack', progress);
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutBack', progress);
        } else {
            builder.get('head')
                .setXRotDegrees(-20)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('chest')
                .setXRotDegrees(10)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_arm')
                .setXRotDegrees(-160)
                .setYRotDegrees(-5)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('right_arm')
                .setXRotDegrees(-160)
                .setYRotDegrees(5)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_leg')
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setZ(1)
                .animate('InOutCubic', progress);
            builder.get('right_leg')
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setZ(1)
                .animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/fire_slam_1', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:flame', 'blaze_column_detonate_2', builder.getPartialTicks());

        if (builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(80)
                .setZRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutBack', progress);
            builder.get('right_arm')
                .setXRotDegrees(80)
                .setZRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutBack', progress);
        } else {
            builder.get('head')
                .setXRotDegrees(60)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('chest')
                .setXRotDegrees(20)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_arm')
                .setXRotDegrees(90)
                .setYRotDegrees(-20)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('right_arm')
                .setXRotDegrees(90)
                .setYRotDegrees(20)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_leg')
                .setXRotDegrees(5)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setZ(3)
                .animate('InOutCubic', progress);
            builder.get('right_leg')
                .setXRotDegrees(30)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setY(10)
                .setZ(-1.5)
                .animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/shadow_fire_slam_0', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:shadow_flame', 'blaze_column_detonate', builder.getPartialTicks());

        if (builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutBack', progress);
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutBack', progress);
        } else {
            builder.get('head')
                .setXRotDegrees(-20)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('chest')
                .setXRotDegrees(10)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_arm')
                .setXRotDegrees(-160)
                .setYRotDegrees(-5)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('right_arm')
                .setXRotDegrees(-160)
                .setYRotDegrees(5)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_leg')
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setZ(1)
                .animate('InOutCubic', progress);
            builder.get('right_leg')
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setZ(1)
                .animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/shadow_fire_slam_1', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:shadow_flame', 'blaze_column_detonate_2', builder.getPartialTicks());

        if (builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(80)
                .setZRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutBack', progress);
            builder.get('right_arm')
                .setXRotDegrees(80)
                .setZRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutBack', progress);
        } else {
            builder.get('head')
                .setXRotDegrees(60)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('chest')
                .setXRotDegrees(20)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_arm')
                .setXRotDegrees(90)
                .setYRotDegrees(-20)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('right_arm')
                .setXRotDegrees(90)
                .setYRotDegrees(20)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_leg')
                .setXRotDegrees(5)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setZ(3)
                .animate('InOutCubic', progress);
            builder.get('right_leg')
                .setXRotDegrees(30)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .setY(10)
                .setZ(-1.5)
                .animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/earth_shield', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:earth', 'earth_shield_block', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setYRotDegrees(-10).setZRotDegrees(80).setXRotDegrees(-80).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-85).setYRotDegrees(50).setZRotDegrees(0).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/rune_shield', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:earth', 'charge_shield', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setYRotDegrees(-10).setZRotDegrees(80).setXRotDegrees(-80).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-85).setYRotDegrees(50).setZRotDegrees(0).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setYRotDegrees(-10).setZRotDegrees(80).setXRotDegrees(-80).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-85).setYRotDegrees(50).setZRotDegrees(0).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/meteor_shower', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:earth', 'hand_anim_meteor', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(38).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-35).setYRotDegrees(35).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-35).setYRotDegrees(-35).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/thunderclap', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:lightning', 'rapid_teleport_timer', builder.getPartialTicks());

        if (builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutBack', progress);
            builder.get('right_arm')
                .setXRotDegrees(-85)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutBack', progress);
        } else {
            builder.get('chest')
                .setXRotDegrees(10)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_arm')
                .setXRotDegrees(-160)
                .setYRotDegrees(-5)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('right_arm')
                .setXRotDegrees(-160)
                .setYRotDegrees(5)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/thunderclap_2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:lightning', 'rapid_teleport_timer_2', builder.getPartialTicks());

        if (builder.isFirstPerson()) {
            builder.get('left_arm')
                .setXRotDegrees(80)
                .setZRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutBack', progress);
            builder.get('right_arm')
                .setXRotDegrees(80)
                .setZRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutBack', progress);
        } else {
            builder.get('chest')
                .setXRotDegrees(20)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('left_arm')
                .setXRotDegrees(90)
                .setYRotDegrees(-20)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
            builder.get('right_arm')
                .setXRotDegrees(90)
                .setYRotDegrees(20)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/stomp1', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:earth', 'tremor_stomp_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-10).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-20).moveZ(2).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/stomp2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:earth', 'tremor_stomp_animation2', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_leg').setZRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_leg').setXRotDegrees(75).setX(-2).setY(12).setZ(-4).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_leg').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_leg').setXRotDegrees(-5).setX(2).setY(5).setZ(-2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(20).setY(1).setZ(-3).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(15).setZ(-2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').moveY(-8).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/water_beam_water', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:water', 'water_beam_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-70).setYRotDegrees(-15).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-70).setYRotDegrees(15).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/ripple_burst_1', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:water', 'ripple_burst_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(-10).moveZ(2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(-20).moveZ(2).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/ripple_burst_2', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:water', 'ripple_burst_animation2', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_leg').setZRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_leg').setXRotDegrees(75).setX(-2).setY(12).setZ(-4).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_leg').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_leg').setXRotDegrees(-5).setX(2).setY(5).setZ(-2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-45).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('head').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('head').setXRotDegrees(20).setY(1).setZ(-3).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('chest').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('chest').setXRotDegrees(15).setZ(-2).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').moveY(-8).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/piercing_rain', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:water', 'hand_anim_piercing_rain', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-20).setZRotDegrees(-40).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-40).setZRotDegrees(-30).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-20).setZRotDegrees(40).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-40).setZRotDegrees(30).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/tornado_gust', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:wind', 'hand_anim_tornado_gust', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setXRotDegrees(-160).setYRotDegrees(-40).moveY(5).moveZ(-3).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(-50).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setXRotDegrees(-160).setYRotDegrees(40).moveY(5).moveZ(-3).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/wind_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:wind", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:wind', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:wind", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:wind', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/will_dodge', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:inner_will", "Reflex.Dodge.First")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:inner_will', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(-45).moveZ(1).moveX(-4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(-26)
                    .setZRotDegrees(-3).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(-4)
                    .setZRotDegrees(-4).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:inner_will", "Reflex.Dodge.Second")) {
            let animation_dodge = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:inner_will', 'Reflex.Dodge.Anim', builder.getPartialTicks());
            if (animation_dodge > 0 && !builder.isFirstPerson()) {
                builder.get('body')
                    .rotateYDegrees(45).moveZ(-1).moveX(4).animate('easeOutBack', animation_dodge);
                builder.get('right_arm')
                    .setXRotDegrees(20)
                    .setYRotDegrees(4)
                    .setZRotDegrees(4).animate('InOutCubic', animation_dodge);

                builder.get('left_arm')
                    .setXRotDegrees(-44)
                    .setYRotDegrees(26)
                    .setZRotDegrees(3).animate('InOutCubic', animation_dodge);

                builder.get('right_leg')
                    .setXRotDegrees(-5)
                    .setYRotDegrees(-7.5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);

                builder.get('left_leg')
                    .setXRotDegrees(7.5)
                    .setYRotDegrees(-5)
                    .setZRotDegrees(0).animate('InOutCubic', animation_dodge);
            }
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/hell_core_charge_hands', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:flame', 'hand_anim_hell_core', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/hell_core_charge_hands_shadow_flame', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:shadow_flame', 'hand_anim_hell_core', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-120).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/deku_smash', 15, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:deku", "deku_smash")) {
            const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:deku', 'deku_smash', builder.getPartialTicks(), 0, 4);
            if (progress > 0.0 && !builder.isFirstPerson()) {


                builder.get('right_arm')
                    .setZ(4)
                    .setXRotDegrees(-95)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutCubic', progress);
                builder.get('left_arm')
                    .setXRotDegrees(-28)
                    .setYRotDegrees(-7)
                    .setZRotDegrees(7)
                    .animate('InOutCubic', progress);
                builder.get('body')
                    .rotateYDegrees(-47)
                    .animate('InOutCubic', progress);
                builder.get('head')
                    .rotateYDegrees(-47)
                    .animate('InOutCubic', progress);
            }
            if (progress > 0.0 && builder.isFirstPerson()) {


                builder.get('right_arm')
                    .setY(-3)
                    .animate('InOutCubic', progress);
            }
        }
    }
    );
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/flame_absorb', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:flame', 'absorb_flames_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/flame_absorb_shadow', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:shadowflame', 'absorb_flames_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setZRotDegrees(20).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-90).setXRotDegrees(-25).animate('InOutCubic', progress);
        }
    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/flame_spew', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:flame', 'flame_spew_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/shadow_flame_spew', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:shadow_flame', 'flame_spew_anim', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('body').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('body').setXRotDegrees(-15).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/uplift', 10, (builder) => {
        const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'elementia:wind', 'uplift_animation', builder.getPartialTicks());
        if (builder.isFirstPerson()) {
            builder.get('right_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('right_arm').setZRotDegrees(35).setXRotDegrees(20).animate('InOutCubic', progress);
        }
        if (builder.isFirstPerson()) {
            builder.get('left_arm').setXRotDegrees(0).animate('InOutCubic', progress);
        } else {
            builder.get('left_arm').setZRotDegrees(-35).setXRotDegrees(20).animate('InOutCubic', progress);
        }

    });
});
PalladiumEvents.registerAnimations((event) => {
    event.register('elementia/deku_hands', 10, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "elementia:deku", "Punch.First")) {
            if (!builder.isFirstPerson()) {
                const halfPi = 1.57079632679;

                builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(2) //backwards and forwards
                    .translateY(6) //up and down
                    .translateX(6); // left and right

                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi + 0.2)
                    .setYRot(builder.getModel().head.yRot)
                    .setZRot(builder.getModel().head.zRot)
                    .translateZ(-2) //backwards and forwards
                    .translateY(-1.5) //up and down
                    .translateX(-7); // left and right
            }
            if (builder.isFirstPerson()) {
                builder.get('right_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(-32)
                    .setZRotDegrees(-33)
                    .setY(0.5)
                    .setX(-4.5)
                    .setZ(2);

                builder.get('left_arm')
                    .setXRotDegrees(8.5)
                    .setYRotDegrees(32)
                    .setZRotDegrees(33)
                    .setY(-4)
                    .setX(3)
                    .setZ(4);
            }
        }
    });

});
