let Minecraft = Java.loadClass('net.minecraft.client.Minecraft');
const RenderSystem = Java.loadClass('com.mojang.blaze3d.systems.RenderSystem');
//The render power screen event
PalladiumEvents.renderPowerScreen(e => {
    //Get Entity Client Sided
    let entity = Minecraft.getInstance().player
    if (!entity) return;
    let width = e.screen.width / 2
    let height = e.screen.height / 2
    //Checks to see if the tab is the requested power, or if you want to use it for a namespace, you can use: e.tab.toString().includes(`namespace:`)
    if (e.tab.toString().includes('elementia:')) {
        let element_tab = e.tab.toString().slice(e.tab.toString().indexOf(':') + 1)
        let score = palladium.scoreboard.getScore(entity, `elementia.${element_tab}.score`, 0)
        let mana = palladium.scoreboard.getScore(entity, 'Mana.Score', 0)
        {
            let size = 27
            e.guiGraphics.blit(new ResourceLocation(`elementia:textures/icons/elemental_circle.png`),
                ((width) - 155), ((height) - 90), (0), (0), (size), (size), (size), (size));
        }
        {
            let size = 26
            e.guiGraphics.blit(new ResourceLocation(`elementia:textures/icons/mana_circle.png`),
                ((width) - 155), ((height) - 60), (0), (0), (size), (size), (size), (size));
        }
        {
            let size = 257
            //You can design it the way you want
            e.guiGraphics.blit(new ResourceLocation(`elementia:textures/gui/ability_bars/sandstone_border.png`),
                //X, Y, Move through an object X (Prob Just Leave 0), Move through an object Y (Prob Just Leave 0), How Many Images Widthwise(10=1), How Many Images Heightwise(10=1), Width Stretch, Length Stretch
                ((width) - 126), ((height) - 98), (0), (0), (size), (size), (size), (size));
        }
        //graphics stuff, string, X, Y, hex colour(0xHex Code)
        palladium.gui.drawString(e.guiGraphics, Component.string(score), ((width) - 147), ((height) - 81), 0xFFFFFF);
        palladium.gui.drawString(e.guiGraphics, Component.string(mana), ((width) - 147), ((height) - 51), 0xFFFFFF);
    }
    if (e.tab.toString().includes('elementia:')) {
        let tab_name = e.tab.toString().replace('elementia:', '')
        let level_word = tab_name.toString().toUpperCase().replace(tab_name.toString().slice(1).toUpperCase(), "") + tab_name.toString().slice(1)

        let Level = palladium.scoreboard.getScore(entity, `${level_word}.Level`, 0)
        {
            let size = 40
            e.guiGraphics.blit(new ResourceLocation(`elementia:textures/icons/${tab_name}/${tab_name}_mastery.png`),
                (width - -78), (height - 80), (0), (0), (size), (size), (size), (size));
        }
        palladium.gui.drawString(e.guiGraphics, Component.string(Level), (width - -94), (height - 56), 0xFFFFFF)
    }
});