PlayerEvents.tick(event => {
    const player = event.player;
    const username = player.getGameProfile().getName();


    let ElementiaTickCounter = player.persistentData.ElementiaTickCounter || 0;

    ElementiaTickCounter++;

    // Mana
    let manaScoreboardObj = Utils.server.scoreboard.getObjective("Elementia.Mana");
    let manaScore = Utils.server.scoreboard.getOrCreatePlayerScore(username, manaScoreboardObj);
    let mana = manaScore.getScore();
    if (isNaN(mana)) mana = 0;

    let manaMaxScoreboardObj = Utils.server.scoreboard.getObjective("Elementia.Mana.Max");
    let manaMaxScore = Utils.server.scoreboard.getOrCreatePlayerScore(username, manaMaxScoreboardObj);
    let mana_max = manaMaxScore.getScore();
    if (isNaN(mana_max) || mana_max === 0) mana_max = 50;

    let mana_max_amount = 0;
    if (mana_max < 2000) mana_max_amount = mana_max;
    else mana_max_amount = 2000;

    let manaUseScoreboardObj = Utils.server.scoreboard.getObjective("Elementia.Mana.Use");
    let manaUseScore = Utils.server.scoreboard.getOrCreatePlayerScore(username, manaUseScoreboardObj);
    let mana_use = manaUseScore.getScore();
    if (isNaN(mana_use)) mana_use = 0;

    const mana_regen_raw = mana_max * 0.0110;
    let mana_regen = Math.max(1, Math.round(mana_regen_raw));
    if (mana_max > 2000) mana_regen = 16;


    let mana_diff = parseFloat((mana / mana_max) * 100);
    if (isNaN(mana_diff)) mana_diff = 0;

    palladium.scoreboard.setScore(player, "Elementia.Mana.Diff", Math.round(mana_diff));


    if (ElementiaTickCounter % 80 === 0 && player.getTags().contains("Has.Element")) {

        if (mana < mana_max) {
            palladium.scoreboard.addScore(player, "Elementia.Mana", mana_regen);
        }
    }
    if (player && player.getTags().contains("element")) {

        if (mana_use >= mana_max_amount) {
            palladium.scoreboard.setScore(player, "Elementia.Mana.Use", 0);
            palladium.scoreboard.addScore(player, "Elementia.Mana.Max", 1);
        }
    }
    player.persistentData.ElementiaTickCounter = ElementiaTickCounter;
});
