
const WeightFullList = [
    { power: 'elementia:earth', weight: 10, name: "Earth Elemental" },
    { power: 'elementia:flame', weight: 10, name: "Flame Elemental" },
    { power: 'elementia:lightning', weight: 10, name: "Lightning Elemental" },
    { power: 'elementia:water', weight: 10, name: "Water Elemental" },
    { power: 'elementia:wind', weight: 10, name: "Wind Elemental" },
    { power: 'elementia:nature', weight: 10, name: "Nature Elemental" },
];
// Function to pick a random power based on weights
function getRandomPowerW() {
    const totalWeight_Weight = WeightFullList.reduce((acc, power) => acc + power.weight, 0);
    let random = Math.random() * totalWeight_Weight;

    for (const power of WeightFullList) {
        if (random < power.weight) {
            return power;
        }
        random -= power.weight;
    }
}
// Function to get a random score within a given range
function getRandomScoreW(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}
ItemEvents.rightClicked(event => {
    const { player, item, server } = event;

    // Check if the power is "elementia:inner_potential"
    if (item.id === 'elementia:mana_crystal' && superpowerUtil.hasSuperpower(player, "elementia:effects/basic/inner_potential")) {
        // Gives the tags for the powers
        server.runCommandSilent(`execute as ${player.name.string} run superpower add elementia:base_elemental ${player.name.string}`);
        server.runCommandSilent(`execute as ${player.name.string} run tag ${player.name.string} add Awakening.VFX`);

        // Assign random power based on weights
        const assignedPower = getRandomPowerW();

        // Assign the player the corresponding power
        superpowerUtil.addSuperpower(player, assignedPower.power);


    }
});