var elements = [
	'earth',
	'flame',
	'inner_will',
	'lightning',
	'nature',
	'water',
	'wind',
]
ServerEvents.commandRegistry(event => {
	const { commands: Commands, arguments: Arguments } = event
	event.register(
		Commands.literal("elementia")
			.requires(src => src.hasPermission(2))
			.then(Commands.argument('player', Arguments.ENTITY.create(event))
				.then(Commands.argument('operation', Arguments.STRING.create(event))
					.suggests((ctx, builder) => {
						builder.suggest('add')
						builder.suggest('remove')
						return builder.buildFuture()
					})
					.then(Commands.argument('element', Arguments.STRING.create(event))
						.suggests((ctx, builder) => {
							elements.forEach(element => {
								builder.suggest(element)
							})
							return builder.buildFuture()
						})
						.executes(ctx => {
							let player = Arguments.ENTITY.getResult(ctx, 'player')
							let element_long = Arguments.STRING.getResult(ctx, 'element')
							let operation = Arguments.STRING.getResult(ctx, 'operation')

							if (operation == 'remove') {
								palladium.superpowers.removeSuperpower(player, `elementia:${element_long}`)
								player.tell(`Removed ${element_long} element`)
							}
							if (operation == 'add') {
								palladium.superpowers.addSuperpower(player, `elementia:${element_long}`)
								player.tell(`Added ${element_long} element`)
							}
							return 1
						})
					)
				)
			)
	)
})